/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.condition;

import barsuift.simLife.condition.BoundCondition;
import barsuift.simLife.condition.BoundConditionState;
import junit.framework.TestCase;

public class BoundConditionTest
extends TestCase {
    private BoundCondition condition;
    private BoundConditionState state;

    protected void setUp() throws Exception {
        super.setUp();
        this.setUpFromParams(5, 2);
    }

    private void setUpFromParams(int bound, int count) {
        this.state = new BoundConditionState(bound, count);
        this.condition = new BoundCondition(this.state);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.state = null;
        this.condition = null;
    }

    public void testEvaluate0() {
        this.setUpFromParams(0, 0);
        BoundConditionTest.assertFalse((boolean)this.condition.evaluate());
        BoundConditionTest.assertFalse((boolean)this.condition.evaluate());
        BoundConditionTest.assertFalse((boolean)this.condition.evaluate());
        BoundConditionTest.assertFalse((boolean)this.condition.evaluate());
    }

    public void testEvaluate1() {
        this.setUpFromParams(1, 0);
        BoundConditionTest.assertTrue((boolean)this.condition.evaluate());
        BoundConditionTest.assertTrue((boolean)this.condition.evaluate());
        BoundConditionTest.assertTrue((boolean)this.condition.evaluate());
        BoundConditionTest.assertTrue((boolean)this.condition.evaluate());
    }

    public void testEvaluate2() {
        this.setUpFromParams(2, 0);
        BoundConditionTest.assertFalse((boolean)this.condition.evaluate());
        BoundConditionTest.assertTrue((boolean)this.condition.evaluate());
        BoundConditionTest.assertTrue((boolean)this.condition.evaluate());
        BoundConditionTest.assertTrue((boolean)this.condition.evaluate());
    }

    public void testEvaluate3() {
        this.setUpFromParams(5, 2);
        BoundConditionTest.assertFalse((boolean)this.condition.evaluate());
        BoundConditionTest.assertFalse((boolean)this.condition.evaluate());
        BoundConditionTest.assertTrue((boolean)this.condition.evaluate());
        BoundConditionTest.assertTrue((boolean)this.condition.evaluate());
    }

    public void testGetState() throws InterruptedException {
        BoundConditionTest.assertEquals((Object)this.state, (Object)this.condition.getState());
        BoundConditionTest.assertSame((Object)this.state, (Object)this.condition.getState());
        BoundConditionTest.assertEquals((int)2, (int)this.condition.getState().getCount());
        BoundConditionTest.assertEquals((int)5, (int)this.condition.getState().getBound());
        this.condition.evaluate();
        BoundConditionTest.assertEquals((Object)this.state, (Object)this.condition.getState());
        BoundConditionTest.assertSame((Object)this.state, (Object)this.condition.getState());
        BoundConditionTest.assertEquals((int)3, (int)this.condition.getState().getCount());
        BoundConditionTest.assertEquals((int)5, (int)this.condition.getState().getBound());
    }
}

