/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife;

import barsuift.simLife.Randomizer;
import barsuift.simLife.condition.BoundConditionState;
import barsuift.simLife.condition.CyclicConditionState;
import barsuift.simLife.process.ConditionalTaskState;
import barsuift.simLife.process.SplitConditionalTaskState;
import barsuift.simLife.time.SimLifeDateState;
import java.math.BigDecimal;

public final class UtilDataCreatorForTests {
    private UtilDataCreatorForTests() {
    }

    public static BigDecimal createRandomBigDecimal() {
        return new BigDecimal(Math.random());
    }

    public static boolean createRandomBoolean() {
        return Math.random() >= 0.5;
    }

    public static SimLifeDateState createRandomDateState() {
        return new SimLifeDateState((long)(Randomizer.randomBetween((int)0, (int)100) * 1000));
    }

    public static SimLifeDateState createSpecificDateState() {
        return new SimLifeDateState(100000L);
    }

    public static CyclicConditionState createRandomCyclicConditionState() {
        return new CyclicConditionState(Randomizer.randomBetween((int)3, (int)10), Randomizer.randomBetween((int)0, (int)2));
    }

    public static CyclicConditionState createSpecificCyclicConditionState() {
        return new CyclicConditionState(5, 2);
    }

    public static BoundConditionState createRandomBoundConditionState() {
        return new BoundConditionState(Randomizer.randomBetween((int)3, (int)10), Randomizer.randomBetween((int)0, (int)2));
    }

    public static BoundConditionState createSpecificBoundConditionState() {
        return new BoundConditionState(5, 2);
    }

    public static ConditionalTaskState createRandomConditionalTaskState() {
        CyclicConditionState executionCondition = UtilDataCreatorForTests.createRandomCyclicConditionState();
        BoundConditionState endingCondition = UtilDataCreatorForTests.createRandomBoundConditionState();
        return new ConditionalTaskState(executionCondition, endingCondition);
    }

    public static ConditionalTaskState createSpecificConditionalTaskState() {
        CyclicConditionState executionCondition = UtilDataCreatorForTests.createSpecificCyclicConditionState();
        BoundConditionState endingCondition = UtilDataCreatorForTests.createSpecificBoundConditionState();
        return new ConditionalTaskState(executionCondition, endingCondition);
    }

    public static SplitConditionalTaskState createRandomSplitConditionalTaskState() {
        ConditionalTaskState conditionalTask = UtilDataCreatorForTests.createRandomConditionalTaskState();
        int stepSize = Randomizer.randomBetween((int)2, (int)5);
        return new SplitConditionalTaskState(conditionalTask, stepSize);
    }

    public static SplitConditionalTaskState createSpecificSplitConditionalTaskState() {
        ConditionalTaskState conditionalTask = UtilDataCreatorForTests.createSpecificConditionalTaskState();
        int stepSize = 3;
        return new SplitConditionalTaskState(conditionalTask, stepSize);
    }
}

