/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife;

import barsuift.simLife.PercentHelper;
import java.math.BigDecimal;
import junit.framework.TestCase;

public class PercentHelperTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetDecimalValue() {
        BigDecimal value = PercentHelper.getDecimalValue((int)12);
        PercentHelperTest.assertEquals((int)12, (int)value.multiply(new BigDecimal(100)).intValueExact());
        try {
            PercentHelper.getDecimalValue((int)-1);
            PercentHelperTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            PercentHelper.getDecimalValue((int)101);
            PercentHelperTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetIntValue() {
        PercentHelperTest.assertEquals((int)25, (int)PercentHelper.getIntValue((BigDecimal)new BigDecimal("0.25")));
        PercentHelperTest.assertEquals((int)99, (int)PercentHelper.getIntValue((BigDecimal)new BigDecimal("0.99")));
    }

    public void testGetStringValueInt() {
        PercentHelperTest.assertEquals((String)"25.00%", (String)PercentHelper.getStringValue((int)25));
        PercentHelperTest.assertEquals((String)"100.00%", (String)PercentHelper.getStringValue((int)100));
        PercentHelperTest.assertEquals((String)"0.00%", (String)PercentHelper.getStringValue((int)0));
    }

    public void testGetStringValueBigDecimal() {
        PercentHelperTest.assertEquals((String)"25.00%", (String)PercentHelper.getStringValue((BigDecimal)new BigDecimal("0.25")));
        PercentHelperTest.assertEquals((String)"100.00%", (String)PercentHelper.getStringValue((BigDecimal)new BigDecimal("1")));
        PercentHelperTest.assertEquals((String)"0.00%", (String)PercentHelper.getStringValue((BigDecimal)new BigDecimal("0")));
        PercentHelperTest.assertEquals((String)"25.12%", (String)PercentHelper.getStringValue((BigDecimal)new BigDecimal("0.25123")));
    }
}

