/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.time;

import barsuift.simLife.Persistent;
import barsuift.simLife.time.Day;
import barsuift.simLife.time.Month;
import barsuift.simLife.time.SimLifeCalendarState;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.regex.Pattern;

public class SimLifeCalendar
extends Calendar
implements Persistent<SimLifeCalendarState> {
    private static final long serialVersionUID = -2239086430259505817L;
    private static final MessageFormat STRING_FORMAT = new MessageFormat("{0,number,00}:{1,number,00} {2} {3,number,00} {4} {5,number,0000}");
    private static final Pattern spacePattern = Pattern.compile(" ");
    private static final Pattern colonPattern = Pattern.compile(":");
    private static final int EPOCH_MILLIS = 0;
    static final int CURRENT_ERA = 0;
    static final int WIM = Month.WIM.getIndex();
    static final int SPRIM = Month.SPRIM.getIndex();
    static final int SUM = Month.SUM.getIndex();
    static final int TOM = Month.TOM.getIndex();
    public static final int NOSDAY = Day.NOSDAY.getIndex();
    public static final int WATSDAY = Day.WATSDAY.getIndex();
    public static final int STOODAY = Day.STOODAY.getIndex();
    public static final int FIRDAY = Day.FIRDAY.getIndex();
    public static final int THUNSDAY = Day.THUNSDAY.getIndex();
    public static final int WINDAY = Day.WINDAY.getIndex();
    public static final int MS_PER_SECOND = 1000;
    public static final int SECOND_PER_MINUTE = 60;
    public static final int MINUTE_PER_DAY = 20;
    public static final int DAY_PER_WEEK = 6;
    public static final int WEEK_PER_MONTH = 3;
    public static final int DAY_PER_MONTH = 18;
    public static final int MONTH_PER_YEAR = 4;
    public static final int WEEK_PER_YEAR = 12;
    public static final int DAY_PER_YEAR = 72;
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final long ONE_DAY = 1200000L;
    private static final long ONE_WEEK = 0x6DDD00L;
    private static final long ONE_MONTH = 21600000L;
    private static final long ONE_YEAR = 86400000L;
    static final int[] MIN_VALUES = new int[]{0, 1, WIM, 1, 1, 1, 1, NOSDAY, 1, 0, 0, 0, 0, 0, 0, 0, 0};
    static final int[] MAX_VALUES = new int[]{0, 292269054, TOM, 12, 3, 18, 72, WINDAY, 3, 0, 0, 0, 19, 59, 999, 0, 0};
    private final SimLifeCalendarState state;

    public SimLifeCalendar() {
        this.time = 0L;
        this.set(1, 1);
        this.set(2, WIM);
        this.set(5, 1);
        this.set(12, 0);
        this.set(13, 0);
        this.state = new SimLifeCalendarState(this.getTimeInMillis());
    }

    public SimLifeCalendar(String date) {
        this.setTime(date);
        this.state = new SimLifeCalendarState(this.getTimeInMillis());
    }

    public SimLifeCalendar(long millis) {
        this.setTimeInMillis(millis);
        this.state = new SimLifeCalendarState(millis);
    }

    public SimLifeCalendar(SimLifeCalendar copy) {
        long timeInMillis = copy.getTimeInMillis();
        this.setTimeInMillis(timeInMillis);
        this.state = new SimLifeCalendarState(timeInMillis);
    }

    public SimLifeCalendar(SimLifeCalendarState calendarState) {
        if (calendarState == null) {
            throw new IllegalArgumentException("calendar state is null");
        }
        this.setTimeInMillis(calendarState.getValue());
        this.state = calendarState;
    }

    @Override
    public SimLifeCalendarState getState() {
        this.synchronize();
        return this.state;
    }

    @Override
    public void synchronize() {
        this.state.setValue(this.getTimeInMillis());
    }

    @Override
    protected void computeTime() {
        long result = this.computeTimeInDays();
        result = result * 20L + (long)this.internalGet(12);
        result = result * 60L + (long)this.internalGet(13);
        this.time = result = result * 1000L + (long)this.internalGet(14);
    }

    private long computeTimeInDays() {
        long result = this.internalGet(1) - 1;
        if (this.isSet(2)) {
            result = result * 4L + (long)this.internalGet(2) - 1L;
            if (this.isSet(5)) {
                return result * 18L + (long)this.internalGet(5) - 1L;
            }
            result *= 3L;
            if (this.isSet(4)) {
                result += (long)(this.internalGet(4) - 1);
            } else if (this.isSet(8)) {
                result += (long)(this.internalGet(8) - 1);
            }
            result *= 6L;
            if (this.isSet(7)) {
                result += (long)(this.internalGet(7) - 1);
            }
            return result;
        }
        if (this.isSet(6)) {
            return result * 72L + (long)this.internalGet(6) - 1L;
        }
        result *= 12L;
        if (this.isSet(3)) {
            result += (long)(this.internalGet(3) - 1);
        }
        result *= 6L;
        if (this.isSet(7)) {
            result += (long)(this.internalGet(7) - 1);
        }
        return result;
    }

    @Override
    protected void computeFields() {
        long relativeTime = this.time - 0L;
        long absDay = relativeTime / 1200000L;
        int dayOfMonth = (int)(absDay % 18L);
        this.fields[0] = 0;
        this.fields[1] = (int)(absDay / 72L) + 1;
        this.fields[2] = (int)(absDay / 18L % 4L) + 1;
        this.fields[3] = (int)(absDay / 6L % 12L) + 1;
        this.fields[4] = dayOfMonth / 6 + 1;
        this.fields[5] = dayOfMonth + 1;
        this.fields[6] = (int)(absDay % 72L) + 1;
        this.fields[7] = dayOfMonth % 6 + 1;
        this.fields[8] = dayOfMonth / 6 + 1;
        this.fields[9] = 0;
        this.fields[10] = 0;
        this.fields[11] = 0;
        this.fields[12] = (int)(relativeTime % 1200000L) / 60000;
        this.fields[13] = (int)(relativeTime % 60000L) / 1000;
        this.fields[14] = (int)(relativeTime % 1000L);
    }

    @Override
    public void add(int field, int amount) {
        if (amount == 0) {
            return;
        }
        if (field < 0 || field >= 15) {
            throw new IllegalArgumentException("Invalid field " + field);
        }
        this.complete();
        long delta = amount;
        switch (field) {
            case 0: {
                return;
            }
            case 1: {
                delta *= 86400000L;
                break;
            }
            case 2: {
                delta *= 21600000L;
                break;
            }
            case 3: {
                delta *= 0x6DDD00L;
                break;
            }
            case 4: {
                delta *= 0x6DDD00L;
                break;
            }
            case 5: {
                delta *= 1200000L;
                break;
            }
            case 6: {
                delta *= 1200000L;
                break;
            }
            case 7: {
                delta *= 1200000L;
                break;
            }
            case 8: {
                delta *= 0x6DDD00L;
                break;
            }
            case 9: {
                return;
            }
            case 10: {
                return;
            }
            case 11: {
                return;
            }
            case 12: {
                delta *= 60000L;
                break;
            }
            case 13: {
                delta *= 1000L;
                break;
            }
        }
        this.setTimeInMillis(this.time + delta);
    }

    @Override
    public void roll(int field, boolean up) {
        this.roll(field, up ? 1 : -1);
    }

    @Override
    public void roll(int field, int amount) {
        if (amount == 0) {
            return;
        }
        if (field < 0 || field >= 15) {
            throw new IllegalArgumentException("Invalid field " + field);
        }
        this.complete();
        int min = this.getMinimum(field);
        int max = this.getMaximum(field);
        int range = max - min + 1;
        int rolledValue = this.internalGet(field) + (amount %= range);
        if (rolledValue > max) {
            rolledValue -= range;
        } else if (rolledValue < min) {
            rolledValue += range;
        }
        this.set(field, rolledValue);
    }

    @Override
    public int getMinimum(int field) {
        return MIN_VALUES[field];
    }

    @Override
    public int getMaximum(int field) {
        return MAX_VALUES[field];
    }

    @Override
    public int getGreatestMinimum(int field) {
        return MIN_VALUES[field];
    }

    @Override
    public int getLeastMaximum(int field) {
        return MAX_VALUES[field];
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SimLifeCalendar && super.equals(obj);
    }

    public String formatDate() {
        return STRING_FORMAT.format(new Object[]{this.get(12), this.get(13), Day.values()[this.get(7) - 1], this.get(5), Month.values()[this.get(2) - 1], this.get(1)});
    }

    public void setTime(String date) {
        String[] elements = spacePattern.split(date);
        String minSec = elements[0];
        String[] minSecElements = colonPattern.split(minSec);
        this.set(12, Integer.parseInt(minSecElements[0]));
        this.set(13, Integer.parseInt(minSecElements[1]));
        this.set(14, 0);
        this.set(7, Day.valueOf(elements[1].toUpperCase()).getIndex());
        this.set(5, Integer.parseInt(elements[2]));
        this.set(2, Month.valueOf(elements[3].toUpperCase()).getIndex());
        this.set(1, Integer.parseInt(elements[4]));
        this.computeTime();
    }
}

