/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;

public final class PercentHelper {
    private static final NumberFormat percentFormat = NumberFormat.getPercentInstance(Locale.US);

    private PercentHelper() {
    }

    public static BigDecimal getDecimalValue(int value) {
        if (value < 0 || value > 100) {
            throw new IllegalArgumentException("Value is not between 0 and 100 but is " + value);
        }
        BigDecimal tmpValue = new BigDecimal(value);
        return tmpValue.movePointLeft(2);
    }

    public static int getIntValue(BigDecimal value) {
        BigDecimal tmpValue = value.movePointRight(2);
        return tmpValue.setScale(0, RoundingMode.HALF_DOWN).intValueExact();
    }

    public static String getStringValue(int value) {
        return percentFormat.format(PercentHelper.getDecimalValue(value));
    }

    public static String getStringValue(BigDecimal value) {
        return percentFormat.format(value);
    }

    static {
        percentFormat.setMinimumFractionDigits(2);
    }
}

