/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.time;

import barsuift.simLife.time.SimLifeCalendar;
import barsuift.simLife.time.SimLifeCalendarState;
import junit.framework.TestCase;

public class SimLifeCalendarTest
extends TestCase {
    private SimLifeCalendar calendar;

    protected void setUp() throws Exception {
        super.setUp();
        this.calendar = new SimLifeCalendar();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.calendar = null;
    }

    public void testConstructorString() {
        this.calendar = new SimLifeCalendar("19:59 Firday 04 Sprim 0003");
        SimLifeCalendarTest.assertEquals((String)"19:59 Firday 04 Sprim 0003", (String)this.calendar.formatDate());
        SimLifeCalendarTest.assertEquals((long)199199000L, (long)this.calendar.getTimeInMillis());
        this.calendar = new SimLifeCalendar("06:13 Winday 12 Tom 0001");
        SimLifeCalendarTest.assertEquals((String)"06:13 Winday 12 Tom 0001", (String)this.calendar.formatDate());
        SimLifeCalendarTest.assertEquals((long)78373000L, (long)this.calendar.getTimeInMillis());
    }

    public void testConstructorCopy() {
        this.calendar.setTimeInMillis(199199000L);
        SimLifeCalendar cal2 = new SimLifeCalendar(this.calendar);
        SimLifeCalendarTest.assertEquals((Object)this.calendar, (Object)cal2);
        SimLifeCalendarTest.assertEquals((long)199199000L, (long)cal2.getTimeInMillis());
    }

    public void testConstructorLong() {
        this.calendar = new SimLifeCalendar(199199000L);
        SimLifeCalendarTest.assertEquals((long)199199000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((String)"19:59 Firday 04 Sprim 0003", (String)this.calendar.formatDate());
        this.calendar = new SimLifeCalendar(199200000L);
        SimLifeCalendarTest.assertEquals((long)199200000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((String)"00:00 Thunsday 05 Sprim 0003", (String)this.calendar.formatDate());
        this.calendar = new SimLifeCalendar(78373000L);
        SimLifeCalendarTest.assertEquals((long)78373000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((String)"06:13 Winday 12 Tom 0001", (String)this.calendar.formatDate());
    }

    public void testConstructorState() {
        SimLifeCalendarState calendarState = new SimLifeCalendarState();
        calendarState.setValue(199199000L);
        this.calendar = new SimLifeCalendar(calendarState);
        SimLifeCalendarTest.assertEquals((long)199199000L, (long)this.calendar.getTimeInMillis());
        try {
            new SimLifeCalendar((SimLifeCalendarState)null);
            SimLifeCalendarTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAdd() {
        SimLifeCalendarTest.assertEquals((long)0L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(13));
        this.calendar.add(14, 1);
        SimLifeCalendarTest.assertEquals((long)1L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(13));
        this.calendar.add(14, 499);
        SimLifeCalendarTest.assertEquals((long)500L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)500, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(13));
        this.calendar.add(14, 500);
        SimLifeCalendarTest.assertEquals((long)1000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(13));
        this.calendar.add(13, 19);
        SimLifeCalendarTest.assertEquals((long)20000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)20, (int)this.calendar.get(13));
        this.calendar.add(13, 40);
        SimLifeCalendarTest.assertEquals((long)60000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(13));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(12));
        this.calendar.add(12, 10);
        SimLifeCalendarTest.assertEquals((long)660000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(13));
        SimLifeCalendarTest.assertEquals((int)11, (int)this.calendar.get(12));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(5));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.NOSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(6));
        this.calendar.add(12, 19);
        SimLifeCalendarTest.assertEquals((long)1800000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(13));
        SimLifeCalendarTest.assertEquals((int)10, (int)this.calendar.get(12));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(5));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.WATSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(6));
        this.calendar.add(10, 1);
        SimLifeCalendarTest.assertEquals((long)1800000L, (long)this.calendar.getTimeInMillis());
        this.calendar.add(11, 1);
        SimLifeCalendarTest.assertEquals((long)1800000L, (long)this.calendar.getTimeInMillis());
        this.calendar.add(7, 1);
        SimLifeCalendarTest.assertEquals((long)3000000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(13));
        SimLifeCalendarTest.assertEquals((int)10, (int)this.calendar.get(12));
        SimLifeCalendarTest.assertEquals((int)3, (int)this.calendar.get(5));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.STOODAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)3, (int)this.calendar.get(6));
        this.calendar.add(5, 1);
        SimLifeCalendarTest.assertEquals((long)4200000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(13));
        SimLifeCalendarTest.assertEquals((int)10, (int)this.calendar.get(12));
        SimLifeCalendarTest.assertEquals((int)4, (int)this.calendar.get(5));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.FIRDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)4, (int)this.calendar.get(6));
        this.calendar.add(6, 1);
        SimLifeCalendarTest.assertEquals((long)5400000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(13));
        SimLifeCalendarTest.assertEquals((int)10, (int)this.calendar.get(12));
        SimLifeCalendarTest.assertEquals((int)5, (int)this.calendar.get(5));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.THUNSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)5, (int)this.calendar.get(6));
        this.calendar.add(7, 1);
        SimLifeCalendarTest.assertEquals((long)6600000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.WINDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(3));
        this.calendar.add(7, 1);
        SimLifeCalendarTest.assertEquals((long)7800000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.NOSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(3));
        this.calendar.add(4, 1);
        SimLifeCalendarTest.assertEquals((long)15000000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.NOSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)3, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)3, (int)this.calendar.get(3));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(2));
        this.calendar.add(3, 1);
        SimLifeCalendarTest.assertEquals((long)22200000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.NOSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)4, (int)this.calendar.get(3));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(2));
        this.calendar.add(2, 1);
        SimLifeCalendarTest.assertEquals((long)43800000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.NOSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)7, (int)this.calendar.get(3));
        SimLifeCalendarTest.assertEquals((int)3, (int)this.calendar.get(2));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(1));
        this.calendar.add(2, 2);
        SimLifeCalendarTest.assertEquals((long)87000000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(3));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(2));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(1));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(0));
        this.calendar.add(1, 1);
        SimLifeCalendarTest.assertEquals((long)173400000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(3));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(2));
        SimLifeCalendarTest.assertEquals((int)3, (int)this.calendar.get(1));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(0));
        this.calendar.add(0, 1);
        SimLifeCalendarTest.assertEquals((int)3, (int)this.calendar.get(1));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(0));
    }

    public void testRoll() {
        SimLifeCalendarTest.assertEquals((long)0L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(13));
        this.calendar.roll(14, 1);
        SimLifeCalendarTest.assertEquals((long)1L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(13));
        this.calendar.roll(14, 499);
        SimLifeCalendarTest.assertEquals((long)500L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)500, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(13));
        this.calendar.roll(14, 500);
        SimLifeCalendarTest.assertEquals((long)0L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(13));
        this.calendar.roll(13, 20);
        SimLifeCalendarTest.assertEquals((long)20000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)20, (int)this.calendar.get(13));
        this.calendar.roll(13, 40);
        SimLifeCalendarTest.assertEquals((long)0L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(13));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(12));
        this.calendar.roll(12, 10);
        SimLifeCalendarTest.assertEquals((long)600000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(13));
        SimLifeCalendarTest.assertEquals((int)10, (int)this.calendar.get(12));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(5));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.NOSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(6));
        this.calendar.roll(12, 10);
        SimLifeCalendarTest.assertEquals((long)0L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(13));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(12));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(5));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.NOSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(6));
        this.calendar.roll(10, 1);
        SimLifeCalendarTest.assertEquals((long)0L, (long)this.calendar.getTimeInMillis());
        this.calendar.roll(11, 1);
        SimLifeCalendarTest.assertEquals((long)0L, (long)this.calendar.getTimeInMillis());
        this.calendar = new SimLifeCalendar();
        this.calendar.clear(2);
        this.calendar.clear(5);
        this.calendar.set(3, 1);
        this.calendar.set(7, 1);
        this.calendar.roll(7, 1);
        SimLifeCalendarTest.assertEquals((long)1200000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(12));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(5));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.WATSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(6));
        this.calendar = new SimLifeCalendar();
        this.calendar.roll(5, 1);
        SimLifeCalendarTest.assertEquals((long)1200000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(12));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(5));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.WATSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(6));
        this.calendar = new SimLifeCalendar();
        this.calendar.clear(2);
        this.calendar.clear(5);
        this.calendar.roll(6, 1);
        SimLifeCalendarTest.assertEquals((long)1200000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(12));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(5));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.WATSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(6));
        this.calendar = new SimLifeCalendar();
        this.calendar.clear(2);
        this.calendar.clear(5);
        this.calendar.set(3, 1);
        this.calendar.roll(7, 1);
        this.calendar.roll(7, 1);
        SimLifeCalendarTest.assertEquals((long)2400000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.STOODAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(3));
        this.calendar.roll(7, 1);
        SimLifeCalendarTest.assertEquals((long)3600000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.FIRDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(3));
        this.calendar.roll(7, 1);
        SimLifeCalendarTest.assertEquals((long)4800000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.THUNSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(3));
        this.calendar.roll(7, 1);
        SimLifeCalendarTest.assertEquals((long)6000000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.WINDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(3));
        this.calendar.roll(7, 1);
        SimLifeCalendarTest.assertEquals((long)0L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.NOSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(3));
        this.calendar = new SimLifeCalendar();
        this.calendar.clear(5);
        this.calendar.set(7, SimLifeCalendar.NOSDAY);
        this.calendar.roll(4, 1);
        SimLifeCalendarTest.assertEquals((long)0x6DDD00L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.NOSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(3));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(2));
        this.calendar = new SimLifeCalendar();
        this.calendar.clear(2);
        this.calendar.roll(3, 1);
        SimLifeCalendarTest.assertEquals((long)0x6DDD00L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.NOSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(3));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(2));
        this.calendar = new SimLifeCalendar();
        this.calendar.clear(5);
        this.calendar.set(7, SimLifeCalendar.NOSDAY);
        this.calendar.roll(4, 1);
        this.calendar.roll(4, 1);
        SimLifeCalendarTest.assertEquals((long)14400000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.NOSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)3, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)3, (int)this.calendar.get(3));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(2));
        this.calendar.roll(4, 1);
        SimLifeCalendarTest.assertEquals((long)0L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.NOSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(3));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(2));
        this.calendar = new SimLifeCalendar();
        this.calendar.roll(2, 1);
        SimLifeCalendarTest.assertEquals((long)21600000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.NOSDAY, (int)this.calendar.get(7));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)4, (int)this.calendar.get(3));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(2));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(1));
        this.calendar.roll(2, 3);
        SimLifeCalendarTest.assertEquals((long)0L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(3));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(2));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(1));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(0));
        this.calendar = new SimLifeCalendar();
        this.calendar.roll(1, 1);
        SimLifeCalendarTest.assertEquals((long)86400000L, (long)this.calendar.getTimeInMillis());
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(4));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(3));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.get(2));
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(1));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(0));
        this.calendar.roll(0, 1);
        SimLifeCalendarTest.assertEquals((int)2, (int)this.calendar.get(1));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.get(0));
    }

    public void testGetMinimum() {
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getMinimum(0));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.getMinimum(1));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.WIM, (int)this.calendar.getMinimum(2));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.getMinimum(3));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.getMinimum(4));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.getMinimum(5));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.getMinimum(6));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.NOSDAY, (int)this.calendar.getMinimum(7));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.getMinimum(8));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getMinimum(9));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getMinimum(10));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getMinimum(11));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getMinimum(12));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getMinimum(13));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getMinimum(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getMinimum(15));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getMinimum(16));
    }

    public void testGetMaximum() {
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getMaximum(0));
        SimLifeCalendarTest.assertEquals((int)292269054, (int)this.calendar.getMaximum(1));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.TOM, (int)this.calendar.getMaximum(2));
        SimLifeCalendarTest.assertEquals((int)12, (int)this.calendar.getMaximum(3));
        SimLifeCalendarTest.assertEquals((int)3, (int)this.calendar.getMaximum(4));
        SimLifeCalendarTest.assertEquals((int)18, (int)this.calendar.getMaximum(5));
        SimLifeCalendarTest.assertEquals((int)72, (int)this.calendar.getMaximum(6));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.WINDAY, (int)this.calendar.getMaximum(7));
        SimLifeCalendarTest.assertEquals((int)3, (int)this.calendar.getMaximum(8));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getMaximum(9));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getMaximum(10));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getMaximum(11));
        SimLifeCalendarTest.assertEquals((int)19, (int)this.calendar.getMaximum(12));
        SimLifeCalendarTest.assertEquals((int)59, (int)this.calendar.getMaximum(13));
        SimLifeCalendarTest.assertEquals((int)999, (int)this.calendar.getMaximum(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getMaximum(15));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getMaximum(16));
    }

    public void testGetGreatestMinimum() {
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getGreatestMinimum(0));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.getGreatestMinimum(1));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.WIM, (int)this.calendar.getGreatestMinimum(2));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.getGreatestMinimum(3));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.getGreatestMinimum(4));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.getGreatestMinimum(5));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.getGreatestMinimum(6));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.NOSDAY, (int)this.calendar.getGreatestMinimum(7));
        SimLifeCalendarTest.assertEquals((int)1, (int)this.calendar.getGreatestMinimum(8));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getGreatestMinimum(9));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getGreatestMinimum(10));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getGreatestMinimum(11));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getGreatestMinimum(12));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getGreatestMinimum(13));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getGreatestMinimum(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getGreatestMinimum(15));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getGreatestMinimum(16));
    }

    public void testGetLeastMaximum() {
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getLeastMaximum(0));
        SimLifeCalendarTest.assertEquals((int)292269054, (int)this.calendar.getLeastMaximum(1));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.TOM, (int)this.calendar.getLeastMaximum(2));
        SimLifeCalendarTest.assertEquals((int)12, (int)this.calendar.getLeastMaximum(3));
        SimLifeCalendarTest.assertEquals((int)3, (int)this.calendar.getLeastMaximum(4));
        SimLifeCalendarTest.assertEquals((int)18, (int)this.calendar.getLeastMaximum(5));
        SimLifeCalendarTest.assertEquals((int)72, (int)this.calendar.getLeastMaximum(6));
        SimLifeCalendarTest.assertEquals((int)SimLifeCalendar.WINDAY, (int)this.calendar.getLeastMaximum(7));
        SimLifeCalendarTest.assertEquals((int)3, (int)this.calendar.getLeastMaximum(8));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getLeastMaximum(9));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getLeastMaximum(10));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getLeastMaximum(11));
        SimLifeCalendarTest.assertEquals((int)19, (int)this.calendar.getLeastMaximum(12));
        SimLifeCalendarTest.assertEquals((int)59, (int)this.calendar.getLeastMaximum(13));
        SimLifeCalendarTest.assertEquals((int)999, (int)this.calendar.getLeastMaximum(14));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getLeastMaximum(15));
        SimLifeCalendarTest.assertEquals((int)0, (int)this.calendar.getLeastMaximum(16));
    }

    public void testFormatDate() {
        SimLifeCalendarTest.assertEquals((String)"00:00 Nosday 01 Wim 0001", (String)this.calendar.formatDate());
        this.calendar.set(14, 999);
        SimLifeCalendarTest.assertEquals((String)"00:00 Nosday 01 Wim 0001", (String)this.calendar.formatDate());
        this.calendar.set(13, 59);
        this.calendar.set(12, 19);
        this.calendar.clear(2);
        this.calendar.set(7, SimLifeCalendar.FIRDAY);
        SimLifeCalendarTest.assertEquals((String)"19:59 Firday 04 Wim 0001", (String)this.calendar.formatDate());
        this.calendar = new SimLifeCalendar();
        this.calendar.set(7, SimLifeCalendar.STOODAY);
        this.calendar.set(5, 15);
        SimLifeCalendarTest.assertEquals((String)"00:00 Stooday 15 Wim 0001", (String)this.calendar.formatDate());
        this.calendar.set(2, SimLifeCalendar.TOM);
        SimLifeCalendarTest.assertEquals((String)"00:00 Stooday 15 Tom 0001", (String)this.calendar.formatDate());
        this.calendar.set(1, 12);
        SimLifeCalendarTest.assertEquals((String)"00:00 Stooday 15 Tom 0012", (String)this.calendar.formatDate());
        this.calendar.set(1, 499);
        SimLifeCalendarTest.assertEquals((String)"00:00 Stooday 15 Tom 0499", (String)this.calendar.formatDate());
        this.calendar.set(1, 12345);
        SimLifeCalendarTest.assertEquals((String)"00:00 Stooday 15 Tom 12345", (String)this.calendar.formatDate());
        this.calendar.set(1, 123456789);
        SimLifeCalendarTest.assertEquals((String)"00:00 Stooday 15 Tom 123456789", (String)this.calendar.formatDate());
        this.calendar = new SimLifeCalendar();
        this.calendar.clear(5);
        this.calendar.set(7, SimLifeCalendar.WINDAY);
        SimLifeCalendarTest.assertEquals((String)"00:00 Winday 06 Wim 0001", (String)this.calendar.formatDate());
    }

    public void testSetTime() {
        this.calendar.setTime("19:59 Firday 04 Sprim 0003");
        SimLifeCalendarTest.assertEquals((String)"19:59 Firday 04 Sprim 0003", (String)this.calendar.formatDate());
        SimLifeCalendarTest.assertEquals((long)199199000L, (long)this.calendar.getTimeInMillis());
        this.calendar.setTime("06:13 Winday 12 Tom 0001");
        SimLifeCalendarTest.assertEquals((String)"06:13 Winday 12 Tom 0001", (String)this.calendar.formatDate());
        SimLifeCalendarTest.assertEquals((long)78373000L, (long)this.calendar.getTimeInMillis());
    }

    public void testGetState() {
        SimLifeCalendarState state = new SimLifeCalendarState(123L);
        this.calendar = new SimLifeCalendar(state);
        SimLifeCalendarTest.assertEquals((Object)state, (Object)this.calendar.getState());
        SimLifeCalendarTest.assertSame((Object)state, (Object)this.calendar.getState());
        SimLifeCalendarTest.assertEquals((long)123L, (long)this.calendar.getState().getValue());
        this.calendar.add(14, 1);
        SimLifeCalendarTest.assertEquals((Object)state, (Object)this.calendar.getState());
        SimLifeCalendarTest.assertSame((Object)state, (Object)this.calendar.getState());
        SimLifeCalendarTest.assertEquals((long)124L, (long)this.calendar.getState().getValue());
    }
}

