/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife;

import barsuift.simLife.Percent;
import barsuift.simLife.PercentState;
import java.math.BigDecimal;
import java.util.Locale;
import junit.framework.TestCase;

public class PercentTest
extends TestCase {
    public void testPercentRandom() {
        for (int index = 0; index < 1000; ++index) {
            double value = new Percent().getValue().doubleValue();
            PercentTest.assertTrue((value >= 0.0 ? 1 : 0) != 0);
            PercentTest.assertTrue((value <= 1.0 ? 1 : 0) != 0);
        }
    }

    public void testPercentInt() {
        Percent percent = new Percent(12);
        PercentTest.assertEquals((int)12, (int)percent.getValue().multiply(new BigDecimal(100)).intValueExact());
        try {
            new Percent(-1);
            PercentTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new Percent(101);
            PercentTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPercentPercentState() {
        PercentState percentState = new PercentState();
        percentState.setValue(new BigDecimal("0.34"));
        Percent percent = new Percent(percentState);
        PercentTest.assertEquals((int)34, (int)percent.getValue().multiply(new BigDecimal(100)).intValueExact());
        try {
            new Percent((PercentState)null);
            PercentTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        percentState.setValue(null);
        try {
            new Percent(percentState);
            PercentTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        percentState.setValue(new BigDecimal("-0.01"));
        try {
            new Percent(percentState);
            PercentTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        percentState.setValue(new BigDecimal("1.01"));
        try {
            new Percent(percentState);
            PercentTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPercentBigDecimal() {
        Percent percent = new Percent(new BigDecimal("0.12"));
        PercentTest.assertEquals((int)12, (int)percent.getValue().multiply(new BigDecimal(100)).intValueExact());
        try {
            new Percent((BigDecimal)null);
            PercentTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new Percent(new BigDecimal(-0.01));
            PercentTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new Percent(new BigDecimal(1.01));
            PercentTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPercentPercent() {
        Percent percent1 = new Percent(12);
        Percent percent2 = new Percent(percent1);
        PercentTest.assertEquals((int)12, (int)percent2.getValue().multiply(new BigDecimal(100)).intValueExact());
        try {
            new Percent((Percent)null);
            PercentTest.fail((String)"Should throw an NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetIntValue() {
        Percent percent1 = new Percent(12);
        Percent percent2 = new Percent(100);
        Percent percent3 = new Percent(0);
        Percent percent4 = new Percent(new BigDecimal(0.123));
        Percent percent5 = new Percent(new BigDecimal(0.159));
        PercentTest.assertEquals((int)12, (int)percent1.getIntValue());
        PercentTest.assertEquals((int)100, (int)percent2.getIntValue());
        PercentTest.assertEquals((int)0, (int)percent3.getIntValue());
        PercentTest.assertEquals((int)12, (int)percent4.getIntValue());
        PercentTest.assertEquals((int)16, (int)percent5.getIntValue());
    }

    public void testToString() {
        Percent percent = new Percent(12);
        PercentTest.assertEquals((String)"12.00%", (String)percent.toString());
        Percent.resetPercentFormat((Locale)Locale.FRENCH);
        Percent percent2 = new Percent(12);
        PercentTest.assertEquals((String)"12,00 %", (String)percent2.toString());
        Percent.resetPercentFormat((Locale)Locale.UK);
        Percent percent3 = new Percent(12);
        PercentTest.assertEquals((String)"12.00%", (String)percent3.toString());
    }

    public void testEquals() {
        Percent percent1 = new Percent(new BigDecimal("0.12"));
        Percent percent2 = new Percent(12);
        Percent percent3 = new Percent(percent2);
        Percent.resetPercentFormat((Locale)Locale.ITALY);
        Percent percent4 = new Percent(12);
        Percent.resetPercentFormat((Locale)Locale.CHINESE);
        Percent percent5 = new Percent(12);
        PercentTest.assertEquals((Object)percent1, (Object)percent1);
        PercentTest.assertEquals((Object)percent1, (Object)percent2);
        PercentTest.assertEquals((Object)percent1, (Object)percent3);
        PercentTest.assertEquals((Object)percent2, (Object)percent1);
        PercentTest.assertEquals((Object)percent2, (Object)percent2);
        PercentTest.assertEquals((Object)percent2, (Object)percent3);
        PercentTest.assertEquals((Object)percent3, (Object)percent1);
        PercentTest.assertEquals((Object)percent3, (Object)percent2);
        PercentTest.assertEquals((Object)percent3, (Object)percent3);
        PercentTest.assertEquals((Object)percent2, (Object)percent4);
        PercentTest.assertEquals((Object)percent2, (Object)percent5);
        PercentTest.assertEquals((Object)percent4, (Object)percent5);
    }

    public void testHashcode() {
        Percent percent1 = new Percent(new BigDecimal("0.12"));
        Percent percent2 = new Percent(12);
        Percent percent2bis = new Percent(13);
        Percent percent3 = new Percent(percent2);
        Percent.resetPercentFormat((Locale)Locale.ITALY);
        Percent percent4 = new Percent(12);
        Percent.resetPercentFormat((Locale)Locale.CHINESE);
        Percent percent5 = new Percent(12);
        PercentTest.assertEquals((int)percent1.hashCode(), (int)percent1.hashCode());
        PercentTest.assertEquals((int)percent1.hashCode(), (int)percent2.hashCode());
        PercentTest.assertEquals((int)percent1.hashCode(), (int)percent3.hashCode());
        PercentTest.assertEquals((int)percent2.hashCode(), (int)percent1.hashCode());
        PercentTest.assertEquals((int)percent2.hashCode(), (int)percent2.hashCode());
        PercentTest.assertEquals((int)percent2.hashCode(), (int)percent3.hashCode());
        PercentTest.assertEquals((int)percent3.hashCode(), (int)percent1.hashCode());
        PercentTest.assertEquals((int)percent3.hashCode(), (int)percent2.hashCode());
        PercentTest.assertEquals((int)percent3.hashCode(), (int)percent3.hashCode());
        PercentTest.assertEquals((int)percent2.hashCode(), (int)percent4.hashCode());
        PercentTest.assertEquals((int)percent2.hashCode(), (int)percent5.hashCode());
        PercentTest.assertEquals((int)percent4.hashCode(), (int)percent5.hashCode());
        PercentTest.assertFalse((boolean)percent2.equals((Object)percent2bis));
        PercentTest.assertFalse((boolean)percent1.equals(null));
        PercentTest.assertFalse((boolean)percent1.equals((Object)new BigDecimal(0.12)));
    }
}

