/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife;

import barsuift.simLife.PercentHelper;
import barsuift.simLife.PercentState;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;

public class Percent
implements Comparable<Percent> {
    private static NumberFormat percentFormat;
    private final BigDecimal value;

    static NumberFormat getPercentFormat() {
        return percentFormat;
    }

    static void resetPercentFormat(Locale locale) {
        percentFormat = NumberFormat.getPercentInstance(locale);
        percentFormat.setMinimumFractionDigits(2);
    }

    public Percent() {
        this.value = new BigDecimal(Math.random());
    }

    public Percent(Percent percent) {
        this.value = percent.getValue();
    }

    public Percent(PercentState percentState) {
        if (percentState == null || percentState.getValue() == null || percentState.getValue().doubleValue() < 0.0 || percentState.getValue().doubleValue() > 1.0) {
            throw new IllegalArgumentException("percent state is not between 0 and 1 (or is null)");
        }
        this.value = percentState.getValue();
    }

    public Percent(int value) {
        this.value = PercentHelper.getDecimalValue(value);
    }

    public Percent(BigDecimal value) {
        if (value == null || value.doubleValue() < 0.0 || value.doubleValue() > 1.0) {
            throw new IllegalArgumentException("Value is not between 0 and 1 (or is null) but is " + value);
        }
        this.value = value;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public int getIntValue() {
        BigDecimal tmpValue = this.value.movePointRight(2);
        return tmpValue.setScale(0, RoundingMode.HALF_DOWN).intValueExact();
    }

    public PercentState getState() {
        return new PercentState(this.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Percent other = (Percent)obj;
        return this.value.compareTo(other.value) == 0;
    }

    public String toString() {
        return percentFormat.format(this.getValue());
    }

    @Override
    public int compareTo(Percent o) {
        return this.value.compareTo(o.value);
    }

    static {
        Percent.resetPercentFormat(Locale.US);
    }
}

