/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d;

import barsuift.simLife.State;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Tuple3dState
implements State {
    private double x;
    private double y;
    private double z;

    public Tuple3dState() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Tuple3dState(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Tuple3dState(Tuple3d point) {
        this.x = point.x;
        this.y = point.y;
        this.z = point.z;
    }

    public Point3d toPointValue() {
        return new Point3d(this.x, this.y, this.z);
    }

    public Vector3d toVectorValue() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple3dState other = (Tuple3dState)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public String toString() {
        return "Tuple3dState [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }
}

