/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.j3d.DisplayDataCreatorForTests;
import barsuift.simLife.message.BasicPublisher;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.process.SplitConditionalTask;
import barsuift.simLife.process.Synchronizer3D;
import barsuift.simLife.process.Synchronizer3DState;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CyclicBarrier;

public class MockSynchronizer3D
extends BasicPublisher
implements Synchronizer3D {
    private CyclicBarrier barrier;
    private boolean running;
    private int scheduleCalled;
    private List<SplitConditionalTask> tasksToSchedule;
    private int unscheduleCalled;
    private List<SplitConditionalTask> tasksToUnschedule;
    private int startCalled;
    private int stopCalled;
    private Synchronizer3DState state;
    private int synchronizeCalled;
    private int stepSize;
    private int updateCounter;
    private List<Publisher> publisherObjectsSubscribed;
    private List<Object> arguments;

    public MockSynchronizer3D() {
        super(null);
        this.reset();
    }

    public void reset() {
        this.barrier = new CyclicBarrier(1);
        this.running = false;
        this.scheduleCalled = 0;
        this.tasksToSchedule = new ArrayList<SplitConditionalTask>();
        this.unscheduleCalled = 0;
        this.tasksToUnschedule = new ArrayList<SplitConditionalTask>();
        this.startCalled = 0;
        this.stopCalled = 0;
        this.state = DisplayDataCreatorForTests.createSpecificSynchronizer3DState();
        this.synchronizeCalled = 0;
        this.stepSize = 1;
        this.updateCounter = 0;
        this.publisherObjectsSubscribed = new ArrayList<Publisher>();
        this.arguments = new ArrayList<Object>();
    }

    public void setBarrier(CyclicBarrier barrier) {
        this.barrier = barrier;
    }

    public CyclicBarrier getBarrier() {
        return this.barrier;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void schedule(SplitConditionalTask task) {
        ++this.scheduleCalled;
        this.tasksToSchedule.add(task);
    }

    public int getNbScheduleCalled() {
        return this.scheduleCalled;
    }

    public List<SplitConditionalTask> getScheduledTasks() {
        return this.tasksToSchedule;
    }

    public void unschedule(SplitConditionalTask task) {
        ++this.unscheduleCalled;
        this.tasksToUnschedule.add(task);
    }

    public int getNbUnscheduleCalled() {
        return this.unscheduleCalled;
    }

    public List<SplitConditionalTask> getUnscheduledTasks() {
        return this.tasksToUnschedule;
    }

    public void start() throws IllegalStateException {
        ++this.startCalled;
    }

    public int getNbStartCalled() {
        return this.startCalled;
    }

    public void stop() {
        ++this.stopCalled;
    }

    public int getNbStopCalled() {
        return this.stopCalled;
    }

    public Synchronizer3DState getState() {
        return this.state;
    }

    public void setState(Synchronizer3DState state) {
        this.state = state;
    }

    public void synchronize() {
        ++this.synchronizeCalled;
    }

    public int getNbSynchronizeCalled() {
        return this.synchronizeCalled;
    }

    public void setStepSize(int stepSize) {
        this.stepSize = stepSize;
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public void update(Publisher publisher, Object arg) {
        ++this.updateCounter;
        this.publisherObjectsSubscribed.add(publisher);
        this.arguments.add(arg);
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public List<Publisher> getPublisherObjectsSubscribed() {
        return this.publisherObjectsSubscribed;
    }

    public int getUpdateCounter() {
        return this.updateCounter;
    }
}

