/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.tree;

import barsuift.simLife.j3d.tree.TreeLeaf3D;
import barsuift.simLife.j3d.tree.TreeLeaf3DState;
import barsuift.simLife.message.BasicPublisher;
import barsuift.simLife.message.MockSubscriber;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;

public class MockTreeLeaf3D
extends MockSubscriber
implements TreeLeaf3D {
    private double area;
    private TreeLeaf3DState state;
    private BranchGroup bg;
    private TransformGroup tg;
    private Point3d attachPoint;
    private int increaseSizeCalled;
    private boolean isMaxSizeReached;
    private int synchronizedCalled;
    private final Publisher publisher = new BasicPublisher((Publisher)this);

    public MockTreeLeaf3D() {
        this.reset();
    }

    public void reset() {
        this.area = 0.0;
        this.state = new TreeLeaf3DState();
        Shape3D shape = new Shape3D();
        this.tg = new TransformGroup();
        this.tg.addChild((Node)shape);
        this.bg = new BranchGroup();
        this.bg.addChild((Node)this.tg);
        this.attachPoint = new Point3d();
        this.increaseSizeCalled = 0;
        this.isMaxSizeReached = false;
        this.synchronizedCalled = 0;
    }

    public double getArea() {
        return this.area;
    }

    public void setArea(double area) {
        this.area = area;
    }

    public Point3d getPosition() {
        return this.attachPoint;
    }

    public void setAttachPoint(Point3d attachPoint) {
        this.attachPoint = attachPoint;
    }

    public TreeLeaf3DState getState() {
        return this.state;
    }

    public void setState(TreeLeaf3DState state) {
        this.state = state;
    }

    public BranchGroup getBranchGroup() {
        return this.bg;
    }

    public void setBranchGroup(BranchGroup bg) {
        this.bg.removeChild((Node)this.tg);
        this.bg = bg;
        bg.addChild((Node)this.tg);
    }

    public TransformGroup getTransformGroup() {
        return this.tg;
    }

    public void setTransformGroup(TransformGroup tg) {
        this.bg.removeChild((Node)tg);
        this.tg = tg;
        this.bg.addChild((Node)tg);
    }

    public void increaseSize() {
        ++this.increaseSizeCalled;
    }

    public int getNbnTimesIncreaseSizeCalled() {
        return this.increaseSizeCalled;
    }

    public boolean isMaxSizeReached() {
        return this.isMaxSizeReached;
    }

    public void setMaxSizeReached(boolean isMaxSizeReached) {
        this.isMaxSizeReached = isMaxSizeReached;
    }

    public void synchronize() {
        ++this.synchronizedCalled;
    }

    public int getNbSynchronize() {
        return this.synchronizedCalled;
    }

    public void addSubscriber(Subscriber subscriber) {
        this.publisher.addSubscriber(subscriber);
    }

    public void deleteSubscriber(Subscriber subscriber) {
        this.publisher.deleteSubscriber(subscriber);
    }

    public void notifySubscribers() {
        this.publisher.notifySubscribers();
    }

    public void notifySubscribers(Object arg) {
        this.publisher.notifySubscribers(arg);
    }

    public void deleteSubscribers() {
        this.publisher.deleteSubscribers();
    }

    public boolean hasChanged() {
        return this.publisher.hasChanged();
    }

    public int countSubscribers() {
        return this.publisher.countSubscribers();
    }

    public void setChanged() {
        this.publisher.setChanged();
    }

    public void clearChanged() {
        this.publisher.clearChanged();
    }
}

