/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d;

import barsuift.simLife.Randomizer;
import barsuift.simLife.UtilDataCreatorForTests;
import barsuift.simLife.j3d.SimLifeCanvas3DState;
import barsuift.simLife.j3d.Transform3DState;
import barsuift.simLife.j3d.Tuple3dState;
import barsuift.simLife.j3d.environment.Environment3DState;
import barsuift.simLife.j3d.environment.Sun3DState;
import barsuift.simLife.j3d.tree.Tree3DState;
import barsuift.simLife.j3d.tree.TreeBranch3DState;
import barsuift.simLife.j3d.tree.TreeBranchPart3DState;
import barsuift.simLife.j3d.tree.TreeLeaf3DState;
import barsuift.simLife.j3d.tree.TreeTrunk3DState;
import barsuift.simLife.j3d.universe.Universe3DState;
import barsuift.simLife.j3d.universe.physic.Gravity3DState;
import barsuift.simLife.j3d.universe.physic.Physics3DState;
import barsuift.simLife.process.SplitConditionalTaskState;
import barsuift.simLife.process.Synchronizer3DState;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3d;

public final class DisplayDataCreatorForTests {
    private DisplayDataCreatorForTests() {
    }

    public static Synchronizer3DState createRandomSynchronizer3DState() {
        return new Synchronizer3DState(Randomizer.randomBetween((int)1, (int)20));
    }

    public static Synchronizer3DState createSpecificSynchronizer3DState() {
        return new Synchronizer3DState(1);
    }

    public static Physics3DState createRandomPhysics3DState() {
        return new Physics3DState();
    }

    public static Physics3DState createSpecificPhysics3DState() {
        return new Physics3DState();
    }

    public static Gravity3DState createRandomGravity3DState() {
        SplitConditionalTaskState gravityTask = UtilDataCreatorForTests.createRandomSplitConditionalTaskState();
        return new Gravity3DState(gravityTask);
    }

    public static Gravity3DState createSpecificGravity3DState() {
        SplitConditionalTaskState gravityTask = UtilDataCreatorForTests.createSpecificSplitConditionalTaskState();
        return new Gravity3DState(gravityTask);
    }

    public static Tuple3dState createRandomTupleState() {
        return new Tuple3dState(Math.random(), Math.random(), Math.random());
    }

    public static Transform3DState createSpecificTransform3DState() {
        return new Transform3DState(new Transform3D());
    }

    public static Transform3DState createRandomTransform3DState() {
        Transform3D transform = new Transform3D();
        transform.setTranslation(new Vector3d(Math.random(), Math.random(), Math.random()));
        Transform3D rotation = new Transform3D();
        rotation.rotY(Randomizer.randomRotation());
        transform.mul(rotation);
        return new Transform3DState(transform);
    }

    public static Sun3DState createRandomSun3DState() {
        return new Sun3DState();
    }

    public static Sun3DState createSpecificSun3DState() {
        return new Sun3DState();
    }

    public static Environment3DState createRandomEnvironment3DState() {
        return new Environment3DState();
    }

    public static Environment3DState createSpecificEnvironment3DState() {
        return new Environment3DState();
    }

    public static Universe3DState createRandomUniverse3DState() {
        Synchronizer3DState synchronizerState = DisplayDataCreatorForTests.createRandomSynchronizer3DState();
        return new Universe3DState(synchronizerState);
    }

    public static Universe3DState createSpecificUniverse3DState() {
        Synchronizer3DState synchronizerState = DisplayDataCreatorForTests.createSpecificSynchronizer3DState();
        return new Universe3DState(synchronizerState);
    }

    public static TreeLeaf3DState createRandomTreeLeaf3DState() {
        Transform3DState transform = DisplayDataCreatorForTests.createRandomTransform3DState();
        Tuple3dState initialEndPoint1 = DisplayDataCreatorForTests.createRandomTupleState();
        Tuple3dState initialEndPoint2 = DisplayDataCreatorForTests.createRandomTupleState();
        Tuple3dState endPoint1 = DisplayDataCreatorForTests.createRandomTupleState();
        Tuple3dState endPoint2 = DisplayDataCreatorForTests.createRandomTupleState();
        return new TreeLeaf3DState(transform, initialEndPoint1, initialEndPoint2, endPoint1, endPoint2);
    }

    public static TreeLeaf3DState createSpecificTreeLeaf3DState() {
        Transform3DState transform = DisplayDataCreatorForTests.createSpecificTransform3DState();
        Tuple3dState initialEndPoint1 = new Tuple3dState(0.2, 0.2, 0.0);
        Tuple3dState initialEndPoint2 = new Tuple3dState(0.2, 0.1, 0.0);
        Tuple3dState endPoint1 = new Tuple3dState(0.4, 0.0, 0.0);
        Tuple3dState endPoint2 = new Tuple3dState(0.2, 0.4, 0.0);
        return new TreeLeaf3DState(transform, initialEndPoint1, initialEndPoint2, endPoint1, endPoint2);
    }

    public static TreeBranchPart3DState createRandomTreeBranchPart3DState() {
        Tuple3dState endPoint = DisplayDataCreatorForTests.createRandomTupleState();
        return new TreeBranchPart3DState(endPoint);
    }

    public static TreeBranch3DState createRandomTreeBranch3DState() {
        Tuple3dState translationVector = DisplayDataCreatorForTests.createRandomTupleState();
        return new TreeBranch3DState(translationVector);
    }

    public static TreeTrunk3DState createRandomTreeTrunk3DState() {
        return new TreeTrunk3DState();
    }

    public static Tree3DState createRandomTree3DState() {
        Tuple3dState translationVector = DisplayDataCreatorForTests.createRandomTupleState();
        return new Tree3DState(translationVector);
    }

    public static SimLifeCanvas3DState createSpecificCanvasState() {
        return new SimLifeCanvas3DState(false);
    }

    public static double[] createSpecificTransform3D() {
        return new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
    }
}

