/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d;

import barsuift.simLife.Randomizer;
import barsuift.simLife.j3d.SimLifeCanvas3DState;
import barsuift.simLife.j3d.Tuple3dState;
import barsuift.simLife.j3d.tree.Tree3DState;
import barsuift.simLife.j3d.tree.TreeBranch3DState;
import barsuift.simLife.j3d.tree.TreeBranchPart3DState;
import barsuift.simLife.j3d.tree.TreeLeaf3DState;
import barsuift.simLife.j3d.tree.TreeTrunk3DState;

public final class DisplayDataCreatorForTests {
    private DisplayDataCreatorForTests() {
    }

    public static Tuple3dState createRandomTupleState() {
        return new Tuple3dState(Math.random(), Math.random(), Math.random());
    }

    public static TreeLeaf3DState createRandomTreeLeaf3DState() {
        Tuple3dState attachPoint = DisplayDataCreatorForTests.createRandomTupleState();
        Tuple3dState initialEndPoint1 = DisplayDataCreatorForTests.createRandomTupleState();
        Tuple3dState initialEndPoint2 = DisplayDataCreatorForTests.createRandomTupleState();
        Tuple3dState endPoint1 = DisplayDataCreatorForTests.createRandomTupleState();
        Tuple3dState endPoint2 = DisplayDataCreatorForTests.createRandomTupleState();
        double rotation = Randomizer.randomRotation();
        return new TreeLeaf3DState(attachPoint, initialEndPoint1, initialEndPoint2, endPoint1, endPoint2, rotation);
    }

    public static TreeLeaf3DState createSpecificTreeLeaf3DState() {
        Tuple3dState attachPoint = new Tuple3dState(0.1, 0.2, 0.0);
        Tuple3dState initialEndPoint1 = new Tuple3dState(0.2, 0.2, 0.0);
        Tuple3dState initialEndPoint2 = new Tuple3dState(0.2, 0.1, 0.0);
        Tuple3dState endPoint1 = new Tuple3dState(0.4, 0.0, 0.0);
        Tuple3dState endPoint2 = new Tuple3dState(0.2, 0.4, 0.0);
        double rotation = 1.0471975511965976;
        return new TreeLeaf3DState(attachPoint, initialEndPoint1, initialEndPoint2, endPoint1, endPoint2, rotation);
    }

    public static TreeBranchPart3DState createRandomTreeBranchPart3DState() {
        Tuple3dState endPoint = DisplayDataCreatorForTests.createRandomTupleState();
        return new TreeBranchPart3DState(endPoint);
    }

    public static TreeBranch3DState createRandomTreeBranch3DState() {
        Tuple3dState translationVector = DisplayDataCreatorForTests.createRandomTupleState();
        return new TreeBranch3DState(translationVector);
    }

    public static TreeTrunk3DState createRandomTreeTrunk3DState() {
        return new TreeTrunk3DState();
    }

    public static Tree3DState createRandomTree3DState() {
        Tuple3dState translationVector = DisplayDataCreatorForTests.createRandomTupleState();
        return new Tree3DState(translationVector);
    }

    public static SimLifeCanvas3DState createSpecificCanvasState() {
        return new SimLifeCanvas3DState(false);
    }

    public static double[] createSpecificTransform3D() {
        return new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
    }
}

