/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d;

import javax.vecmath.Point3d;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Point3dState {
    private double x;
    private double y;
    private double z;

    public Point3dState() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Point3dState(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point3dState(Point3d point) {
        this.x = point.x;
        this.y = point.y;
        this.z = point.z;
    }

    public Point3dState(Point3dState copy) {
        this.x = copy.x;
        this.y = copy.y;
        this.z = copy.z;
    }

    public Point3d toPointValue() {
        return new Point3d(this.x, this.y, this.z);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point3dState other = (Point3dState)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public String toString() {
        return "Point3dState [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }
}

