/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d;

import barsuift.simLife.Randomizer;
import barsuift.simLife.j3d.Point3dState;
import barsuift.simLife.j3d.tree.Tree3DState;
import barsuift.simLife.j3d.tree.TreeBranch3DState;
import barsuift.simLife.j3d.tree.TreeBranchPart3DState;
import barsuift.simLife.j3d.tree.TreeLeaf3DState;
import barsuift.simLife.j3d.tree.TreeTrunk3DState;

public final class DisplayDataCreatorForTests {
    private DisplayDataCreatorForTests() {
    }

    public static Point3dState createRandomPointState() {
        return new Point3dState(Math.random(), Math.random(), Math.random());
    }

    public static TreeLeaf3DState createRandomTreeLeaf3DState() {
        Point3dState attachPoint = DisplayDataCreatorForTests.createRandomPointState();
        Point3dState initialEndPoint1 = DisplayDataCreatorForTests.createRandomPointState();
        Point3dState initialEndPoint2 = DisplayDataCreatorForTests.createRandomPointState();
        Point3dState endPoint1 = DisplayDataCreatorForTests.createRandomPointState();
        Point3dState endPoint2 = DisplayDataCreatorForTests.createRandomPointState();
        double rotation = Randomizer.randomRotation();
        return new TreeLeaf3DState(attachPoint, initialEndPoint1, initialEndPoint2, endPoint1, endPoint2, rotation);
    }

    public static TreeLeaf3DState createSpecificTreeLeaf3DState() {
        Point3dState attachPoint = new Point3dState(0.1, 0.2, 0.0);
        Point3dState initialEndPoint1 = new Point3dState(0.2, 0.2, 0.0);
        Point3dState initialEndPoint2 = new Point3dState(0.2, 0.1, 0.0);
        Point3dState endPoint1 = new Point3dState(0.4, 0.0, 0.0);
        Point3dState endPoint2 = new Point3dState(0.2, 0.4, 0.0);
        double rotation = 1.0471975511965976;
        return new TreeLeaf3DState(attachPoint, initialEndPoint1, initialEndPoint2, endPoint1, endPoint2, rotation);
    }

    public static TreeBranchPart3DState createRandomTreeBranchPart3DState() {
        Point3dState endPoint = DisplayDataCreatorForTests.createRandomPointState();
        return new TreeBranchPart3DState(endPoint);
    }

    public static TreeBranch3DState createRandomTreeBranch3DState() {
        Point3dState translationVector = DisplayDataCreatorForTests.createRandomPointState();
        return new TreeBranch3DState(translationVector);
    }

    public static TreeTrunk3DState createRandomTreeTrunk3DState() {
        return new TreeTrunk3DState();
    }

    public static Tree3DState createRandomTree3DState() {
        Point3dState translationVector = DisplayDataCreatorForTests.createRandomPointState();
        return new Tree3DState(translationVector);
    }
}

