/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.j3d.Mobile;
import barsuift.simLife.j3d.MobileEvent;
import barsuift.simLife.process.AbstractSplitConditionalTask;
import barsuift.simLife.process.SplitConditionalTaskState;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;

public class GravityTask
extends AbstractSplitConditionalTask {
    private final ConcurrentLinkedQueue<Mobile> mobiles = new ConcurrentLinkedQueue();

    public GravityTask(SplitConditionalTaskState state) {
        super(state);
    }

    public void fall(Mobile mobile) {
        this.mobiles.add(mobile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSplitConditionalStep(int stepSize) {
        for (Mobile mobile : this.mobiles) {
            TransformGroup currentTG;
            TransformGroup transformGroup = currentTG = mobile.getTransformGroup();
            synchronized (transformGroup) {
                Transform3D transform = new Transform3D();
                currentTG.getTransform(transform);
                Vector3d translation = new Vector3d();
                transform.get(translation);
                if (translation.y < 0.025 * (double)stepSize) {
                    translation.y = 0.0;
                    this.mobiles.remove(mobile);
                    mobile.setChanged();
                    mobile.notifySubscribers((Object)MobileEvent.FALLEN);
                } else {
                    translation.y -= 0.025 * (double)stepSize;
                }
                transform.setTranslation(translation);
                currentTG.setTransform(transform);
            }
        }
    }

    protected Collection<Mobile> getMobiles() {
        return this.mobiles;
    }
}

