/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.process.AbstractTaskSynchronizer;
import barsuift.simLife.process.ConditionalTask;
import barsuift.simLife.process.SplitConditionalTask;
import barsuift.simLife.process.Synchronizer3D;
import barsuift.simLife.process.Synchronizer3DState;

public class BasicSynchronizer3D
extends AbstractTaskSynchronizer<SplitConditionalTask>
implements Synchronizer3D {
    private static final int RATIO_CORE_3D = 20;
    private final Synchronizer3DState state;
    private int stepSize;
    private int stepBeforeSynchro;
    private int currentStep;

    public BasicSynchronizer3D(Synchronizer3DState state) {
        this.state = state;
        this.stepSize = state.getStepSize();
        this.stepBeforeSynchro = 20 / this.stepSize;
        this.currentStep = 0;
    }

    public void setStepSize(int stepSize) {
        this.stepSize = stepSize;
        this.stepBeforeSynchro = 20 / stepSize;
        for (SplitConditionalTask task : this.getTasks()) {
            task.setStepSize(stepSize);
        }
        for (SplitConditionalTask task : this.getScheduledTasks()) {
            task.setStepSize(stepSize);
        }
    }

    public int getStepSize() {
        return this.stepSize;
    }

    protected int getTemporizerPeriod() {
        return 25;
    }

    public void schedule(SplitConditionalTask task) {
        task.setStepSize(this.stepSize);
        super.schedule((ConditionalTask)task);
    }

    public Synchronizer3DState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setStepSize(this.stepSize);
    }

    protected Runnable createBarrierTask() {
        return new BarrierTask();
    }

    private class BarrierTask
    implements Runnable {
        private BarrierTask() {
        }

        @Override
        public synchronized void run() {
            BasicSynchronizer3D.this.currentStep++;
            BasicSynchronizer3D.this.updateTaskList(true);
            if (BasicSynchronizer3D.this.currentStep == BasicSynchronizer3D.this.stepBeforeSynchro) {
                BasicSynchronizer3D.this.currentStep = 0;
                BasicSynchronizer3D.this.synchronizeWithOthers();
                if (BasicSynchronizer3D.this.isStopAsked()) {
                    BasicSynchronizer3D.this.internalStop();
                }
            }
        }
    }
}

