/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.universe.physic;

import barsuift.simLife.j3d.Mobile;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.j3d.universe.physic.Gravity3D;
import barsuift.simLife.j3d.universe.physic.Gravity3DState;
import barsuift.simLife.process.GravityTask;
import barsuift.simLife.process.SplitConditionalTask;
import barsuift.simLife.process.Synchronizer3D;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;

public class BasicGravity3D
implements Gravity3D {
    private final Gravity3DState state;
    private final Group group;
    private GravityTask gravityTask;

    public BasicGravity3D(Gravity3DState state, Universe3D universe3D) {
        this.state = state;
        this.group = new BranchGroup();
        this.group.setCapability(14);
        this.group.setCapability(13);
        Synchronizer3D synchronizer3D = universe3D.getSynchronizer();
        this.gravityTask = new GravityTask(state.getGravityTask());
        synchronizer3D.schedule((SplitConditionalTask)this.gravityTask);
    }

    public Group getGroup() {
        return this.group;
    }

    public void fall(Mobile mobile) {
        this.gravityTask.fall(mobile);
        this.group.addChild((Node)mobile.getBranchGroup());
    }

    public void isFallen(Mobile mobile) {
        this.group.removeChild((Node)mobile.getBranchGroup());
    }

    public Gravity3DState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.gravityTask.synchronize();
    }
}

