/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.universe;

import barsuift.simLife.j3d.tree.Tree3D;
import barsuift.simLife.j3d.tree.Tree3DState;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.j3d.universe.Universe3DState;
import barsuift.simLife.j3d.universe.physic.Physics3D;
import barsuift.simLife.j3d.util.TransformerHelper;
import barsuift.simLife.process.BasicSynchronizer3D;
import barsuift.simLife.process.Synchronizer3D;
import barsuift.simLife.tree.Tree;
import barsuift.simLife.tree.TreeLeaf;
import barsuift.simLife.universe.Universe;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class BasicUniverse3D
implements Universe3D {
    private final BasicSynchronizer3D synchronizer;
    private final Universe3DState state;
    private BranchGroup root;
    private Set<Node> elements3D;
    private final Universe universe;

    public BasicUniverse3D(Universe3DState state, Universe universe) {
        this.state = state;
        this.universe = universe;
        this.synchronizer = new BasicSynchronizer3D(state.getSynchronizerState());
        this.root = new BranchGroup();
        this.root.setCapability(14);
        this.elements3D = new HashSet<Node>();
    }

    public void initFromUniverse(Universe universe) {
        this.addElement3D((Node)universe.getEnvironment().getEnvironment3D().getGroup());
        this.addElement3D((Node)universe.getPhysics().getPhysics3D().getGroup());
        for (Tree tree : universe.getTrees()) {
            this.addTree(tree.getTree3D());
        }
        for (TreeLeaf treeLeaf : universe.getFallenLeaves()) {
            this.addElement3D((Node)treeLeaf.getTreeLeaf3D().getBranchGroup());
        }
    }

    private void addTree(Tree3D tree3D) {
        Point3d treeOriginPoint = ((Tree3DState)tree3D.getState()).getTranslationVector().toPointValue();
        Transform3D translation = TransformerHelper.getTranslationTransform3D(new Vector3d((Tuple3d)treeOriginPoint));
        TransformGroup transformGroup = new TransformGroup(translation);
        BranchGroup treeBranchGroup = new BranchGroup();
        treeBranchGroup.addChild((Node)transformGroup);
        transformGroup.addChild((Node)tree3D.getBranchGroup());
        this.addElement3D((Node)treeBranchGroup);
    }

    public void addElement3D(Node element3D) {
        this.elements3D.add(element3D);
        this.root.addChild(element3D);
    }

    public Set<Node> getElements3D() {
        return Collections.unmodifiableSet(this.elements3D);
    }

    public Synchronizer3D getSynchronizer() {
        return this.synchronizer;
    }

    public Physics3D getPhysics3D() {
        return this.universe.getPhysics().getPhysics3D();
    }

    public BranchGroup getUniverseRoot() {
        return this.root;
    }

    public Universe3DState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.synchronizer.synchronize();
    }
}

