/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.tree;

import barsuift.simLife.j3d.AppearanceFactory;
import barsuift.simLife.j3d.tree.TreeTrunk3D;
import barsuift.simLife.j3d.tree.TreeTrunk3DState;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.j3d.util.ColorConstants;
import barsuift.simLife.j3d.util.TransformerHelper;
import barsuift.simLife.tree.TreeTrunk;
import com.sun.j3d.utils.geometry.Cylinder;
import javax.media.j3d.Appearance;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;

public class BasicTreeTrunk3D
implements TreeTrunk3D {
    private final TreeTrunk3DState state;
    private Cylinder trunkCylinder;
    private final Group group;

    public BasicTreeTrunk3D(Universe3D universe3D, TreeTrunk3DState state, TreeTrunk trunk) {
        if (universe3D == null) {
            throw new IllegalArgumentException("Null universe 3D");
        }
        if (trunk == null) {
            throw new IllegalArgumentException("Null tree trunk");
        }
        if (state == null) {
            throw new IllegalArgumentException("Null tree trunk 3D state");
        }
        this.state = state;
        Appearance trunkAppearance = new Appearance();
        AppearanceFactory.setColorWithMaterial(trunkAppearance, ColorConstants.brown, new Color3f(0.15f, 0.15f, 0.15f), new Color3f(0.05f, 0.05f, 0.05f));
        this.trunkCylinder = new Cylinder(trunk.getRadius(), trunk.getHeight(), trunkAppearance);
        Vector3d translationVector = new Vector3d();
        translationVector.setY((double)(trunk.getHeight() / 2.0f));
        TransformGroup transformGroup = TransformerHelper.getTranslationTransformGroup(translationVector);
        transformGroup.addChild((Node)this.trunkCylinder);
        this.group = new Group();
        this.group.addChild((Node)transformGroup);
    }

    public Cylinder getTrunk() {
        return this.trunkCylinder;
    }

    public TreeTrunk3DState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
    }

    public Group getGroup() {
        return this.group;
    }
}

