/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.tree;

import barsuift.simLife.j3d.AppearanceFactory;
import barsuift.simLife.j3d.MobileEvent;
import barsuift.simLife.j3d.Transform3DState;
import barsuift.simLife.j3d.Tuple3dState;
import barsuift.simLife.j3d.tree.TreeLeaf3D;
import barsuift.simLife.j3d.tree.TreeLeaf3DState;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.j3d.util.AreaHelper;
import barsuift.simLife.j3d.util.ColorConstants;
import barsuift.simLife.j3d.util.NormalHelper;
import barsuift.simLife.j3d.util.PointHelper;
import barsuift.simLife.message.BasicPublisher;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import barsuift.simLife.tree.LeafEvent;
import barsuift.simLife.tree.TreeLeaf;
import java.math.BigDecimal;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class BasicTreeLeaf3D
implements TreeLeaf3D {
    private static final Color3f SPECULAR_COLOR = new Color3f(0.05f, 0.05f, 0.05f);
    private static final Color3f DIFFUSE_COLOR = new Color3f(0.15f, 0.15f, 0.15f);
    private static final int MAX_INCREASE_FACTOR = 10;
    private final TreeLeaf3DState state;
    private final TransformGroup tg;
    private final Point3d initialEndPoint1;
    private final Point3d initialEndPoint2;
    private Point3d endPoint1;
    private Point3d endPoint2;
    private TriangleArray leafGeometry;
    private final Shape3D leafShape3D;
    private final BranchGroup bg;
    private boolean maxSizeReached;
    private final Point3d maxEndPoint1;
    private final Point3d maxEndPoint2;
    private double area;
    private final Publisher publisher = new BasicPublisher((Publisher)this);

    public BasicTreeLeaf3D(Universe3D universe3D, TreeLeaf3DState state, TreeLeaf leaf) {
        if (universe3D == null) {
            throw new IllegalArgumentException("Null universe 3D");
        }
        if (leaf == null) {
            throw new IllegalArgumentException("Null tree leaf");
        }
        if (state == null) {
            throw new IllegalArgumentException("Null tree leaf 3D state");
        }
        this.state = state;
        this.initialEndPoint1 = state.getInitialEndPoint1().toPointValue();
        this.initialEndPoint2 = state.getInitialEndPoint2().toPointValue();
        this.endPoint1 = state.getEndPoint1().toPointValue();
        this.endPoint2 = state.getEndPoint2().toPointValue();
        this.maxEndPoint1 = this.computeMaxEndPoint(this.initialEndPoint1);
        this.maxEndPoint2 = this.computeMaxEndPoint(this.initialEndPoint2);
        leaf.addSubscriber((Subscriber)this);
        this.leafShape3D = new Shape3D();
        this.createLeafGeometry();
        this.setColor(leaf.getEfficiency());
        this.leafShape3D.setCapability(15);
        this.maxSizeReached = false;
        this.tg = this.createLeafTransformGroup();
        this.bg = this.createLeafBranchGroup();
    }

    private BranchGroup createLeafBranchGroup() {
        BranchGroup leafBranchGroup = new BranchGroup();
        leafBranchGroup.setCapability(17);
        leafBranchGroup.setCapability(14);
        leafBranchGroup.addChild((Node)this.tg);
        return leafBranchGroup;
    }

    private TransformGroup createLeafTransformGroup() {
        TransformGroup transformGroup = new TransformGroup(this.state.getTransform().toTransform3D());
        transformGroup.setCapability(13);
        transformGroup.setCapability(18);
        transformGroup.addChild((Node)this.leafShape3D);
        return transformGroup;
    }

    private void setColor(BigDecimal efficiency) {
        Color3f leafColor = new Color3f(ColorConstants.brownYellow);
        leafColor.interpolate((Tuple3f)ColorConstants.green, efficiency.floatValue());
        Appearance appearance = new Appearance();
        AppearanceFactory.setCullFace(appearance, 0);
        AppearanceFactory.setColorWithMaterial(appearance, leafColor, DIFFUSE_COLOR, SPECULAR_COLOR);
        this.leafShape3D.setAppearance(appearance);
    }

    private void createLeafGeometry() {
        this.leafGeometry = new TriangleArray(3, 3);
        this.leafGeometry.setCapability(1);
        this.leafGeometry.setCoordinate(0, new Point3d(0.0, 0.0, 0.0));
        this.resetGeometryPoints();
        this.leafShape3D.setGeometry((Geometry)this.leafGeometry);
        Vector3f polygonNormal = NormalHelper.computeNormal(new Point3d(0.0, 0.0, 0.0), this.endPoint1, this.endPoint2);
        this.leafGeometry.setNormal(0, polygonNormal);
        this.leafGeometry.setNormal(1, polygonNormal);
        this.leafGeometry.setNormal(2, polygonNormal);
    }

    public double getArea() {
        return this.area;
    }

    public boolean isMaxSizeReached() {
        if (this.maxSizeReached) {
            return true;
        }
        if (!PointHelper.areAlmostEquals(this.endPoint1, this.maxEndPoint1)) {
            return false;
        }
        if (!PointHelper.areAlmostEquals(this.endPoint2, this.maxEndPoint2)) {
            return false;
        }
        this.maxSizeReached = true;
        return true;
    }

    private Point3d computeMaxEndPoint(Point3d initialEndPoint) {
        double maxX = 10.0 * initialEndPoint.getX();
        double maxY = 10.0 * initialEndPoint.getY();
        double maxZ = 10.0 * initialEndPoint.getZ();
        return new Point3d(maxX, maxY, maxZ);
    }

    public void increaseSize() {
        if (this.isMaxSizeReached()) {
            return;
        }
        this.endPoint1.x += this.initialEndPoint1.x;
        this.endPoint1.y += this.initialEndPoint1.y;
        this.endPoint1.z += this.initialEndPoint1.z;
        this.endPoint2.x += this.initialEndPoint2.x;
        this.endPoint2.y += this.initialEndPoint2.y;
        this.endPoint2.z += this.initialEndPoint2.z;
        this.resetGeometryPoints();
    }

    public Point3d getPosition() {
        Transform3D transform3D = new Transform3D();
        this.tg.getTransform(transform3D);
        Vector3d translation = new Vector3d();
        transform3D.get(translation);
        return new Point3d((Tuple3d)translation);
    }

    private void resetGeometryPoints() {
        this.leafGeometry.setCoordinates(1, new Point3d[]{this.endPoint1, this.endPoint2});
        this.area = AreaHelper.computeArea(this.leafGeometry);
    }

    public void update(Publisher publisher, Object arg) {
        if (arg == LeafEvent.EFFICIENCY) {
            TreeLeaf leaf = (TreeLeaf)publisher;
            this.setColor(leaf.getEfficiency());
        }
        if (arg == MobileEvent.FALLING) {
            this.fall();
        }
    }

    private void fall() {
        Transform3D globalTransform = new Transform3D();
        this.leafShape3D.getLocalToVworld(globalTransform);
        this.bg.detach();
        this.tg.setTransform(globalTransform);
    }

    public TreeLeaf3DState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        Transform3D transform3D = new Transform3D();
        this.tg.getTransform(transform3D);
        this.state.setTransform(new Transform3DState(transform3D));
        this.state.setInitialEndPoint1(new Tuple3dState((Tuple3d)this.initialEndPoint1));
        this.state.setInitialEndPoint2(new Tuple3dState((Tuple3d)this.initialEndPoint2));
        this.state.setEndPoint1(new Tuple3dState((Tuple3d)this.endPoint1));
        this.state.setEndPoint2(new Tuple3dState((Tuple3d)this.endPoint2));
    }

    public BranchGroup getBranchGroup() {
        return this.bg;
    }

    public TransformGroup getTransformGroup() {
        return this.tg;
    }

    public void addSubscriber(Subscriber subscriber) {
        this.publisher.addSubscriber(subscriber);
    }

    public void deleteSubscriber(Subscriber subscriber) {
        this.publisher.deleteSubscriber(subscriber);
    }

    public void notifySubscribers() {
        this.publisher.notifySubscribers();
    }

    public void notifySubscribers(Object arg) {
        this.publisher.notifySubscribers(arg);
    }

    public void deleteSubscribers() {
        this.publisher.deleteSubscribers();
    }

    public boolean hasChanged() {
        return this.publisher.hasChanged();
    }

    public int countSubscribers() {
        return this.publisher.countSubscribers();
    }

    public void setChanged() {
        this.publisher.setChanged();
    }

    public void clearChanged() {
        this.publisher.clearChanged();
    }
}

