/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.tree;

import barsuift.simLife.j3d.AppearanceFactory;
import barsuift.simLife.j3d.Tuple3dState;
import barsuift.simLife.j3d.tree.TreeBranchPart3D;
import barsuift.simLife.j3d.tree.TreeBranchPart3DState;
import barsuift.simLife.j3d.tree.TreeLeaf3D;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.j3d.util.ColorConstants;
import barsuift.simLife.tree.TreeBranchPart;
import barsuift.simLife.tree.TreeLeaf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class BasicTreeBranchPart3D
implements TreeBranchPart3D {
    private final TreeBranchPart3DState state;
    private final Point3d endPoint;
    private final Group group;
    private final TreeBranchPart branchPart;

    public BasicTreeBranchPart3D(Universe3D universe3D, TreeBranchPart3DState state, TreeBranchPart branchPart) {
        if (universe3D == null) {
            throw new IllegalArgumentException("Null universe 3D");
        }
        if (state == null) {
            throw new IllegalArgumentException("Null tree branch part 3D state");
        }
        if (branchPart == null) {
            throw new IllegalArgumentException("Null tree branch part");
        }
        this.state = state;
        this.endPoint = state.getEndPoint().toPointValue();
        this.branchPart = branchPart;
        this.group = new Group();
        this.group.setCapability(13);
        this.group.setCapability(14);
        this.createFullTreeBranch(branchPart);
    }

    private void createFullTreeBranch(TreeBranchPart branchPart) {
        this.addBranchShape();
        for (TreeLeaf treeLeaf : branchPart.getLeaves()) {
            this.addLeaf(treeLeaf.getTreeLeaf3D());
        }
    }

    private void addBranchShape() {
        Shape3D branchShape = new Shape3D();
        LineArray branchLine = this.createBranchLine();
        Appearance branchAppearance = new Appearance();
        AppearanceFactory.setColorWithColoringAttributes(branchAppearance, ColorConstants.brown);
        branchShape.setGeometry((Geometry)branchLine);
        branchShape.setAppearance(branchAppearance);
        this.group.addChild((Node)branchShape);
    }

    private LineArray createBranchLine() {
        LineArray branchLine = new LineArray(2, 1);
        branchLine.setCoordinate(0, new Point3d(0.0, 0.0, 0.0));
        branchLine.setCoordinate(1, this.endPoint);
        return branchLine;
    }

    public void addLeaf(TreeLeaf3D leaf) {
        this.group.addChild((Node)leaf.getBranchGroup());
    }

    public Point3d getEndPoint() {
        return this.endPoint;
    }

    public TreeBranchPart3DState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setEndPoint(new Tuple3dState((Tuple3d)this.endPoint));
    }

    public Group getGroup() {
        return this.group;
    }

    public List<TreeLeaf3D> getLeaves() {
        ArrayList<TreeLeaf3D> result = new ArrayList<TreeLeaf3D>();
        Collection leaves = this.branchPart.getLeaves();
        for (TreeLeaf leaf : leaves) {
            result.add(leaf.getTreeLeaf3D());
        }
        return result;
    }
}

