/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.tree;

import barsuift.simLife.j3d.Tuple3dState;
import barsuift.simLife.j3d.tree.Tree3D;
import barsuift.simLife.j3d.tree.Tree3DState;
import barsuift.simLife.j3d.tree.TreeBranch3D;
import barsuift.simLife.j3d.tree.TreeTrunk3D;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.j3d.util.TransformerHelper;
import barsuift.simLife.tree.Tree;
import barsuift.simLife.tree.TreeBranch;
import java.util.ArrayList;
import java.util.List;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class BasicTree3D
implements Tree3D {
    private final Tree3DState state;
    private final Vector3d translationVector;
    private final Tree tree;
    private final BranchGroup branchGroup;

    public BasicTree3D(Universe3D universe3D, Tree3DState state, Tree tree) {
        if (universe3D == null) {
            throw new IllegalArgumentException("Null universe 3D");
        }
        if (state == null) {
            throw new IllegalArgumentException("Null tree 3D state");
        }
        if (tree == null) {
            throw new IllegalArgumentException("Null tree");
        }
        this.state = state;
        this.translationVector = state.getTranslationVector().toVectorValue();
        this.tree = tree;
        this.branchGroup = new BranchGroup();
        this.createTrunkAndBranchesBG();
    }

    private void createTrunkAndBranchesBG() {
        this.branchGroup.addChild((Node)this.tree.getTrunk().getTreeTrunk3D().getGroup());
        List branches = this.tree.getBranches();
        for (TreeBranch branch : branches) {
            TreeBranch3D branch3D = branch.getBranch3D();
            BranchGroup branchBG = this.createBranch(branch3D);
            this.branchGroup.addChild((Node)branchBG);
        }
    }

    private BranchGroup createBranch(TreeBranch3D branch3D) {
        BranchGroup branchBG = new BranchGroup();
        TransformGroup transformGroup = TransformerHelper.getTranslationTransformGroup(branch3D.getTranslationVector());
        branchBG.addChild((Node)transformGroup);
        transformGroup.addChild((Node)branch3D.getGroup());
        return branchBG;
    }

    public List<TreeBranch3D> getBranches() {
        ArrayList<TreeBranch3D> branches3D = new ArrayList<TreeBranch3D>();
        for (TreeBranch treeBranch : this.tree.getBranches()) {
            branches3D.add(treeBranch.getBranch3D());
        }
        return branches3D;
    }

    public TreeTrunk3D getTrunk() {
        return this.tree.getTrunk().getTreeTrunk3D();
    }

    public Tree3DState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setTranslationVector(new Tuple3dState((Tuple3d)this.translationVector));
    }

    public BranchGroup getBranchGroup() {
        return this.branchGroup;
    }
}

