/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.environment;

import barsuift.simLife.environment.Environment;
import barsuift.simLife.j3d.environment.Environment3D;
import barsuift.simLife.j3d.environment.Environment3DState;
import barsuift.simLife.j3d.environment.Sun3D;
import barsuift.simLife.j3d.util.ColorConstants;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.vecmath.Point3d;

public class BasicEnvironment3D
implements Environment3D {
    private static BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
    private final Environment3DState state;
    private final Environment environment;
    private final AmbientLight ambientLight;
    private final Group group;

    public BasicEnvironment3D(Environment3DState state, Environment environment) {
        if (state == null) {
            throw new IllegalArgumentException("Null environment3D state");
        }
        this.state = state;
        this.environment = environment;
        this.ambientLight = new AmbientLight(ColorConstants.grey);
        this.ambientLight.setInfluencingBounds((Bounds)bounds);
        this.group = new BranchGroup();
        this.group.addChild((Node)this.ambientLight);
        this.group.addChild((Node)this.getSun3D().getLight());
    }

    public Group getGroup() {
        return this.group;
    }

    public Sun3D getSun3D() {
        return this.environment.getSun().getSun3D();
    }

    public Environment3DState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
    }
}

