/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d;

import barsuift.simLife.j3d.SimLifeCanvas3D;
import barsuift.simLife.j3d.SimLifeCanvas3DState;
import barsuift.simLife.time.FpsCounter;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.text.MessageFormat;
import javax.media.j3d.J3DGraphics2D;

public class BasicSimLifeCanvas3D
extends SimLifeCanvas3D {
    private static final long serialVersionUID = -8802614056574013014L;
    private static final MessageFormat GRAPHIC_FPS_MESSAGE = new MessageFormat("Graphic FPS={0,number,000} Avg(FPS)={1,number,000}");
    private static final MessageFormat CORE_FPS_MESSAGE = new MessageFormat("Core FPS={0,number,000} Avg(FPS)={1,number,000}");
    private final SimLifeCanvas3DState state;
    private boolean fpsShowing;
    private final FpsCounter graphicFps;
    private final FpsCounter coreFps;
    private BufferedImage drawIm;
    private Graphics2D drawg2d;
    private final J3DGraphics2D render2d;
    private final Font font;

    public BasicSimLifeCanvas3D(FpsCounter coreFpsCounter, SimLifeCanvas3DState state) {
        super(SimpleUniverse.getPreferredConfiguration());
        this.state = state;
        this.fpsShowing = state.isFpsShowing();
        this.coreFps = coreFpsCounter;
        this.graphicFps = new FpsCounter();
        this.font = new Font("Monospaced", 1, 18);
        this.render2d = this.getGraphics2D();
    }

    public void postRender() {
        super.postRender();
        if (this.fpsShowing) {
            this.graphicFps.tick();
            this.drawIm = new BufferedImage(350, 48, 6);
            this.drawg2d = this.drawIm.createGraphics();
            this.drawg2d.setFont(this.font);
            this.drawg2d.setColor(Color.RED);
            String graphicMessage = GRAPHIC_FPS_MESSAGE.format(new Object[]{this.graphicFps.getFps(), this.graphicFps.getAvgFps()});
            String coreMessage = CORE_FPS_MESSAGE.format(new Object[]{this.coreFps.getFps(), this.coreFps.getAvgFps()});
            this.drawg2d.drawString(graphicMessage, 2, 18);
            this.drawg2d.drawString(coreMessage, 2, 42);
            this.render2d.drawAndFlushImage(this.drawIm, 0, 0, (ImageObserver)((Object)this));
        }
    }

    public void setFpsShowing(boolean fpsShowing) {
        this.fpsShowing = fpsShowing;
    }

    public boolean isFpsShowing() {
        return this.fpsShowing;
    }

    public SimLifeCanvas3DState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setFpsShowing(this.fpsShowing);
    }
}

