/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.process.BasicSynchronizer3D;
import barsuift.simLife.process.ConditionalTask;
import barsuift.simLife.process.SplitConditionalTask;
import barsuift.simLife.process.Synchronizer3DState;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CyclicBarrier;

public class MockInstrumentedSynchronizer3D
extends BasicSynchronizer3D {
    private CyclicBarrier barrier;
    private int scheduleCalled;
    private List<SplitConditionalTask> tasksToSchedule;
    private int unscheduleCalled;
    private List<SplitConditionalTask> tasksToUnschedule;
    private int startCalled;
    private int stopCalled;
    private int synchronizeCalled;

    public MockInstrumentedSynchronizer3D(Synchronizer3DState state) {
        super(state);
        this.reset();
    }

    public void reset() {
        this.barrier = new CyclicBarrier(1);
        this.scheduleCalled = 0;
        this.tasksToSchedule = new ArrayList<SplitConditionalTask>();
        this.unscheduleCalled = 0;
        this.tasksToUnschedule = new ArrayList<SplitConditionalTask>();
        this.startCalled = 0;
        this.stopCalled = 0;
        this.synchronizeCalled = 0;
    }

    public void setBarrier(CyclicBarrier barrier) {
        super.setBarrier(barrier);
        this.barrier = barrier;
    }

    public CyclicBarrier getBarrier() {
        return this.barrier;
    }

    public boolean isRunning() {
        return super.isRunning();
    }

    public void schedule(SplitConditionalTask task) {
        super.schedule(task);
        ++this.scheduleCalled;
        this.tasksToSchedule.add(task);
    }

    public int getNbScheduleCalled() {
        return this.scheduleCalled;
    }

    public List<SplitConditionalTask> getScheduledTasks() {
        return this.tasksToSchedule;
    }

    public void unschedule(SplitConditionalTask task) {
        super.unschedule((ConditionalTask)task);
        ++this.unscheduleCalled;
        this.tasksToUnschedule.add(task);
    }

    public int getNbUnscheduleCalled() {
        return this.unscheduleCalled;
    }

    public List<SplitConditionalTask> getUnscheduledTasks() {
        return this.tasksToUnschedule;
    }

    public void start() throws IllegalStateException {
        super.start();
        ++this.startCalled;
    }

    public int getNbStartCalled() {
        return this.startCalled;
    }

    public void stop() {
        super.stop();
        ++this.stopCalled;
    }

    public int getNbStopCalled() {
        return this.stopCalled;
    }

    public Synchronizer3DState getState() {
        return super.getState();
    }

    public void synchronize() {
        super.synchronize();
        ++this.synchronizeCalled;
    }

    public int getNbSynchronizeCalled() {
        return this.synchronizeCalled;
    }

    public void setStepSize(int stepSize) {
        super.setStepSize(stepSize);
    }
}

