/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.UtilDataCreatorForTests;
import barsuift.simLife.j3d.Mobile;
import barsuift.simLife.j3d.MobileEvent;
import barsuift.simLife.j3d.MockMobile;
import barsuift.simLife.j3d.helper.VectorTestHelper;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.PublisherTestHelper;
import barsuift.simLife.process.GravityTask;
import barsuift.simLife.process.SplitConditionalTaskState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;
import junit.framework.TestCase;

public class GravityTaskTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testExecuteSplitConditionalStep() {
        SplitConditionalTaskState state = UtilDataCreatorForTests.createSpecificSplitConditionalTaskState();
        GravityTask gravity = new GravityTask(state);
        gravity.executeSplitConditionalStep(state.getStepSize());
        PublisherTestHelper publisher1 = new PublisherTestHelper();
        MockMobile mobile1 = this.createMockMobileAtPosition(new Vector3d(1.0, 2.0, 3.0));
        publisher1.addSubscriberTo((Publisher)mobile1);
        gravity.fall((Mobile)mobile1);
        PublisherTestHelper publisher2 = new PublisherTestHelper();
        MockMobile mobile2 = this.createMockMobileAtPosition(new Vector3d(1.0, 0.076, 3.0));
        publisher2.addSubscriberTo((Publisher)mobile2);
        gravity.fall((Mobile)mobile2);
        PublisherTestHelper publisher3 = new PublisherTestHelper();
        MockMobile mobile3 = this.createMockMobileAtPosition(new Vector3d(1.0, 0.075, 3.0));
        publisher3.addSubscriberTo((Publisher)mobile3);
        gravity.fall((Mobile)mobile3);
        PublisherTestHelper publisher4 = new PublisherTestHelper();
        MockMobile mobile4 = this.createMockMobileAtPosition(new Vector3d(1.0, 0.074, 3.0));
        publisher4.addSubscriberTo((Publisher)mobile4);
        gravity.fall((Mobile)mobile4);
        PublisherTestHelper publisher5 = new PublisherTestHelper();
        MockMobile mobile5 = this.createMockMobileAtPosition(new Vector3d(1.0, 0.026, 3.0));
        publisher5.addSubscriberTo((Publisher)mobile5);
        gravity.fall((Mobile)mobile5);
        PublisherTestHelper publisher6 = new PublisherTestHelper();
        MockMobile mobile6 = this.createMockMobileAtPosition(new Vector3d(1.0, 0.025, 3.0));
        publisher6.addSubscriberTo((Publisher)mobile6);
        gravity.fall((Mobile)mobile6);
        PublisherTestHelper publisher7 = new PublisherTestHelper();
        MockMobile mobile7 = this.createMockMobileAtPosition(new Vector3d(1.0, 0.024, 3.0));
        publisher7.addSubscriberTo((Publisher)mobile7);
        gravity.fall((Mobile)mobile7);
        gravity.executeSplitConditionalStep(state.getStepSize());
        VectorTestHelper.assertVectorEquals(new Vector3d(1.0, 1.925, 3.0), this.getTranslation(mobile1));
        VectorTestHelper.assertVectorEquals(new Vector3d(1.0, 0.001, 3.0), this.getTranslation(mobile2));
        VectorTestHelper.assertVectorEquals(new Vector3d(1.0, 0.0, 3.0), this.getTranslation(mobile3));
        VectorTestHelper.assertVectorEquals(new Vector3d(1.0, 0.0, 3.0), this.getTranslation(mobile4));
        VectorTestHelper.assertVectorEquals(new Vector3d(1.0, 0.0, 3.0), this.getTranslation(mobile5));
        VectorTestHelper.assertVectorEquals(new Vector3d(1.0, 0.0, 3.0), this.getTranslation(mobile6));
        VectorTestHelper.assertVectorEquals(new Vector3d(1.0, 0.0, 3.0), this.getTranslation(mobile7));
        GravityTaskTest.assertEquals((int)0, (int)publisher1.nbUpdated());
        GravityTaskTest.assertEquals((int)0, (int)publisher1.getUpdateObjects().size());
        GravityTaskTest.assertEquals((int)0, (int)publisher2.nbUpdated());
        GravityTaskTest.assertEquals((int)0, (int)publisher2.getUpdateObjects().size());
        GravityTaskTest.assertEquals((int)1, (int)publisher3.nbUpdated());
        GravityTaskTest.assertEquals((Object)MobileEvent.FALLEN, publisher3.getUpdateObjects().get(0));
        GravityTaskTest.assertEquals((int)1, (int)publisher4.nbUpdated());
        GravityTaskTest.assertEquals((Object)MobileEvent.FALLEN, publisher4.getUpdateObjects().get(0));
        GravityTaskTest.assertEquals((int)1, (int)publisher5.nbUpdated());
        GravityTaskTest.assertEquals((Object)MobileEvent.FALLEN, publisher5.getUpdateObjects().get(0));
        GravityTaskTest.assertEquals((int)1, (int)publisher6.nbUpdated());
        GravityTaskTest.assertEquals((Object)MobileEvent.FALLEN, publisher6.getUpdateObjects().get(0));
        GravityTaskTest.assertEquals((int)1, (int)publisher7.nbUpdated());
        GravityTaskTest.assertEquals((Object)MobileEvent.FALLEN, publisher7.getUpdateObjects().get(0));
        GravityTaskTest.assertTrue((boolean)gravity.getMobiles().contains(mobile1));
        GravityTaskTest.assertTrue((boolean)gravity.getMobiles().contains(mobile2));
        GravityTaskTest.assertFalse((boolean)gravity.getMobiles().contains(mobile3));
        GravityTaskTest.assertFalse((boolean)gravity.getMobiles().contains(mobile4));
        GravityTaskTest.assertFalse((boolean)gravity.getMobiles().contains(mobile5));
        GravityTaskTest.assertFalse((boolean)gravity.getMobiles().contains(mobile6));
        GravityTaskTest.assertFalse((boolean)gravity.getMobiles().contains(mobile7));
    }

    private Vector3d getTranslation(MockMobile mobile) {
        Transform3D transform3D = new Transform3D();
        mobile.getTransformGroup().getTransform(transform3D);
        Vector3d translation = new Vector3d();
        transform3D.get(translation);
        return translation;
    }

    private MockMobile createMockMobileAtPosition(Vector3d translation) {
        MockMobile mobile = new MockMobile();
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(translation);
        TransformGroup tg = new TransformGroup(transform3D);
        mobile.setTransformGroup(tg);
        return mobile;
    }
}

