/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.condition.BoundConditionState;
import barsuift.simLife.condition.CyclicConditionState;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.PublisherTestHelper;
import barsuift.simLife.process.BasicSynchronizer3D;
import barsuift.simLife.process.ConditionalTask;
import barsuift.simLife.process.ConditionalTaskState;
import barsuift.simLife.process.MockSingleSynchronizedTask;
import barsuift.simLife.process.MockSplitConditionalTask;
import barsuift.simLife.process.SplitConditionalTask;
import barsuift.simLife.process.SplitConditionalTaskState;
import barsuift.simLife.process.SynchronizedTask;
import barsuift.simLife.process.Synchronizer3DState;
import java.util.concurrent.CyclicBarrier;
import junit.framework.TestCase;

public class BasicSynchronizer3DTest
extends TestCase {
    private BasicSynchronizer3D synchro;
    private Synchronizer3DState state;
    private MockSplitConditionalTask task;
    private SynchronizedTask barrierReleaser;

    protected void setUp() throws Exception {
        super.setUp();
        this.setUpWithBound(0);
    }

    private void setUpWithBound(int bound) {
        this.state = new Synchronizer3DState(10);
        this.synchro = new BasicSynchronizer3D(this.state);
        ConditionalTaskState conditionalTaskState = new ConditionalTaskState(new CyclicConditionState(1, 0), new BoundConditionState(bound, 0));
        this.task = new MockSplitConditionalTask(new SplitConditionalTaskState(conditionalTaskState, 10));
        this.synchro.schedule((SplitConditionalTask)this.task);
        CyclicBarrier barrier = new CyclicBarrier(2);
        this.synchro.setBarrier(barrier);
        this.barrierReleaser = new MockSingleSynchronizedTask();
        this.barrierReleaser.changeBarrier(barrier);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.state = null;
        this.synchro = null;
        this.task = null;
        this.barrierReleaser = null;
    }

    public void testSetBarrier() {
        try {
            this.synchro.setBarrier(new CyclicBarrier(1));
            BasicSynchronizer3DTest.fail((String)"Should throw an IllegalStateException");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        this.synchro = new BasicSynchronizer3D(this.state);
        try {
            this.synchro.setBarrier(null);
            BasicSynchronizer3DTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetStepSize() throws Exception {
        BasicSynchronizer3DTest.assertEquals((int)10, (int)this.synchro.getStepSize());
        BasicSynchronizer3DTest.assertEquals((int)10, (int)this.task.getState().getStepSize());
        this.synchro.setStepSize(5);
        BasicSynchronizer3DTest.assertEquals((int)5, (int)this.synchro.getStepSize());
        BasicSynchronizer3DTest.assertEquals((int)5, (int)this.task.getState().getStepSize());
        this.synchro.setStepSize(30);
        BasicSynchronizer3DTest.assertEquals((int)30, (int)this.synchro.getStepSize());
        BasicSynchronizer3DTest.assertEquals((int)30, (int)this.task.getState().getStepSize());
        this.setUp();
        this.synchro.start();
        BasicSynchronizer3DTest.assertEquals((int)10, (int)this.synchro.getStepSize());
        BasicSynchronizer3DTest.assertEquals((int)10, (int)this.task.getState().getStepSize());
        this.synchro.setStepSize(5);
        BasicSynchronizer3DTest.assertEquals((int)5, (int)this.synchro.getStepSize());
        BasicSynchronizer3DTest.assertEquals((int)5, (int)this.task.getState().getStepSize());
        this.synchro.setStepSize(30);
        BasicSynchronizer3DTest.assertEquals((int)30, (int)this.synchro.getStepSize());
        BasicSynchronizer3DTest.assertEquals((int)30, (int)this.task.getState().getStepSize());
    }

    public void testStart() throws InterruptedException {
        BasicSynchronizer3DTest.assertFalse((boolean)this.synchro.isRunning());
        BasicSynchronizer3DTest.assertEquals((int)0, (int)this.task.getNbExecuted());
        BasicSynchronizer3DTest.assertEquals((int)0, (int)this.task.getNbIncrementExecuted());
        this.synchro.start();
        Thread.sleep(125L);
        BasicSynchronizer3DTest.assertTrue((boolean)this.synchro.isRunning());
        BasicSynchronizer3DTest.assertTrue((this.task.getNbExecuted() > 0 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((this.task.getNbIncrementExecuted() > 0 ? 1 : 0) != 0);
        this.synchro.stop();
        this.barrierReleaser.run();
        Thread.sleep(125L);
        BasicSynchronizer3DTest.assertFalse((boolean)this.synchro.isRunning());
        int nbExecuted = this.task.getNbExecuted();
        int nbIncrementExecuted = this.task.getNbIncrementExecuted();
        Thread.sleep(125L);
        BasicSynchronizer3DTest.assertEquals((int)nbExecuted, (int)this.task.getNbExecuted());
        BasicSynchronizer3DTest.assertEquals((int)nbIncrementExecuted, (int)this.task.getNbIncrementExecuted());
        new Thread((Runnable)this.barrierReleaser).start();
        Thread.sleep(125L);
        BasicSynchronizer3DTest.assertEquals((int)nbExecuted, (int)this.task.getNbExecuted());
        BasicSynchronizer3DTest.assertEquals((int)nbIncrementExecuted, (int)this.task.getNbIncrementExecuted());
    }

    public void testStartWithBoundedTask() throws InterruptedException {
        this.setUpWithBound(10);
        BasicSynchronizer3DTest.assertFalse((boolean)this.synchro.isRunning());
        BasicSynchronizer3DTest.assertEquals((int)0, (int)this.task.getNbExecuted());
        BasicSynchronizer3DTest.assertEquals((int)0, (int)this.task.getNbIncrementExecuted());
        BasicSynchronizer3DTest.assertFalse((boolean)this.synchro.getTasks().contains(this.task));
        this.synchro.start();
        BasicSynchronizer3DTest.assertTrue((boolean)this.synchro.getTasks().contains(this.task));
        Thread.sleep(150L);
        BasicSynchronizer3DTest.assertTrue((boolean)this.synchro.isRunning());
        BasicSynchronizer3DTest.assertEquals((int)1, (int)this.task.getNbExecuted());
        BasicSynchronizer3DTest.assertEquals((int)10, (int)this.task.getNbIncrementExecuted());
        this.synchro.stop();
        this.barrierReleaser.run();
        Thread.sleep(125L);
        BasicSynchronizer3DTest.assertFalse((boolean)this.synchro.isRunning());
        BasicSynchronizer3DTest.assertEquals((int)1, (int)this.task.getNbExecuted());
        BasicSynchronizer3DTest.assertEquals((int)10, (int)this.task.getNbIncrementExecuted());
        BasicSynchronizer3DTest.assertFalse((boolean)this.synchro.getTasks().contains(this.task));
    }

    public void testPublisher() throws Exception {
        PublisherTestHelper publisherHelper = new PublisherTestHelper();
        publisherHelper.addSubscriberTo((Publisher)this.synchro);
        this.synchro.start();
        BasicSynchronizer3DTest.assertEquals((int)1, (int)publisherHelper.nbUpdated());
        BasicSynchronizer3DTest.assertNull(publisherHelper.getUpdateObjects().get(0));
        publisherHelper.reset();
        Thread.sleep(125L);
        this.synchro.stop();
        this.barrierReleaser.run();
        Thread.sleep(125L);
        BasicSynchronizer3DTest.assertEquals((int)1, (int)publisherHelper.nbUpdated());
        BasicSynchronizer3DTest.assertNull(publisherHelper.getUpdateObjects().get(0));
    }

    public void testIllegalStateException() throws InterruptedException {
        try {
            this.synchro.stop();
            BasicSynchronizer3DTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        this.synchro.start();
        Thread.sleep(125L);
        try {
            this.synchro.start();
            BasicSynchronizer3DTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetState() throws InterruptedException {
        BasicSynchronizer3DTest.assertEquals((Object)this.state, (Object)this.synchro.getState());
        BasicSynchronizer3DTest.assertSame((Object)this.state, (Object)this.synchro.getState());
        BasicSynchronizer3DTest.assertEquals((int)10, (int)this.synchro.getState().getStepSize());
        this.synchro.setStepSize(35);
        BasicSynchronizer3DTest.assertEquals((Object)this.state, (Object)this.synchro.getState());
        BasicSynchronizer3DTest.assertSame((Object)this.state, (Object)this.synchro.getState());
        BasicSynchronizer3DTest.assertEquals((int)35, (int)this.synchro.getState().getStepSize());
    }

    public void testSchedule() throws Exception {
        ConditionalTaskState conditionalTaskState = new ConditionalTaskState(new CyclicConditionState(1, 0), new BoundConditionState(0, 0));
        SplitConditionalTaskState splitConditionalTaskState = new SplitConditionalTaskState(conditionalTaskState, 10);
        MockSplitConditionalTask mockRun1 = new MockSplitConditionalTask(splitConditionalTaskState);
        MockSplitConditionalTask mockRun2 = new MockSplitConditionalTask(splitConditionalTaskState);
        MockSplitConditionalTask mockRun3 = new MockSplitConditionalTask(splitConditionalTaskState);
        try {
            this.synchro.unschedule((ConditionalTask)mockRun1);
            BasicSynchronizer3DTest.fail((String)"Should throw an IllegalStateException");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        this.synchro.schedule((SplitConditionalTask)mockRun1);
        this.synchro.start();
        this.synchro.stop();
        this.barrierReleaser.run();
        Thread.sleep(125L);
        BasicSynchronizer3DTest.assertTrue((mockRun1.getNbExecuted() >= 1 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun2.getNbExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun3.getNbExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun1.getNbIncrementExecuted() >= 10 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun2.getNbIncrementExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun3.getNbIncrementExecuted() == 0 ? 1 : 0) != 0);
        mockRun1.reset();
        this.synchro.schedule((SplitConditionalTask)mockRun2);
        this.synchro.unschedule((ConditionalTask)mockRun2);
        this.synchro.start();
        this.synchro.stop();
        this.barrierReleaser.run();
        Thread.sleep(125L);
        BasicSynchronizer3DTest.assertTrue((mockRun1.getNbExecuted() >= 1 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun2.getNbExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun3.getNbExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun1.getNbIncrementExecuted() >= 10 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun2.getNbIncrementExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun3.getNbIncrementExecuted() == 0 ? 1 : 0) != 0);
        mockRun1.reset();
        this.synchro.schedule((SplitConditionalTask)mockRun2);
        this.synchro.start();
        this.synchro.stop();
        this.barrierReleaser.run();
        Thread.sleep(125L);
        this.synchro.unschedule((ConditionalTask)mockRun2);
        this.synchro.start();
        this.synchro.stop();
        this.barrierReleaser.run();
        Thread.sleep(125L);
        BasicSynchronizer3DTest.assertTrue((mockRun1.getNbExecuted() >= 1 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun2.getNbExecuted() >= 1 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun3.getNbExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun1.getNbExecuted() >= mockRun2.getNbExecuted() ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun1.getNbIncrementExecuted() >= 10 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun2.getNbIncrementExecuted() >= 10 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun3.getNbIncrementExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun1.getNbIncrementExecuted() >= mockRun2.getNbIncrementExecuted() ? 1 : 0) != 0);
        mockRun1.reset();
        mockRun2.reset();
        this.synchro.unschedule((ConditionalTask)mockRun1);
        this.synchro.schedule((SplitConditionalTask)mockRun3);
        this.synchro.start();
        this.synchro.stop();
        this.barrierReleaser.run();
        Thread.sleep(125L);
        BasicSynchronizer3DTest.assertTrue((mockRun1.getNbExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun2.getNbExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun3.getNbExecuted() >= 1 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun1.getNbIncrementExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun2.getNbIncrementExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizer3DTest.assertTrue((mockRun3.getNbIncrementExecuted() >= 10 ? 1 : 0) != 0);
    }
}

