/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.universe.physic;

import barsuift.simLife.j3d.Mobile;
import barsuift.simLife.j3d.MockMobile;
import barsuift.simLife.j3d.universe.BasicUniverse3D;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.j3d.universe.Universe3DState;
import barsuift.simLife.j3d.universe.Universe3DStateFactory;
import barsuift.simLife.j3d.universe.physic.BasicGravity3D;
import barsuift.simLife.j3d.universe.physic.Gravity3DState;
import barsuift.simLife.j3d.universe.physic.Gravity3DStateFactory;
import barsuift.simLife.universe.MockUniverse;
import barsuift.simLife.universe.Universe;
import junit.framework.TestCase;

public class BasicGravity3DTest
extends TestCase {
    private BasicUniverse3D universe3D;
    private Gravity3DState gravity3DState;

    protected void setUp() throws Exception {
        super.setUp();
        Universe3DStateFactory universe3DStateFactory = new Universe3DStateFactory();
        Universe3DState universe3DState = universe3DStateFactory.createRandomUniverse3DState();
        this.universe3D = new BasicUniverse3D(universe3DState, (Universe)new MockUniverse());
        Gravity3DStateFactory gravity3DStateFactory = new Gravity3DStateFactory();
        this.gravity3DState = gravity3DStateFactory.createGravity3DState();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.universe3D = null;
        this.gravity3DState = null;
    }

    public void testGroup() {
        BasicGravity3D gravity3D = new BasicGravity3D(this.gravity3DState, (Universe3D)this.universe3D);
        BasicGravity3DTest.assertTrue((boolean)gravity3D.getGroup().getCapability(14));
        BasicGravity3DTest.assertTrue((boolean)gravity3D.getGroup().getCapability(13));
    }

    public void testFall() {
        BasicGravity3D gravity3D = new BasicGravity3D(this.gravity3DState, (Universe3D)this.universe3D);
        BasicGravity3DTest.assertEquals((int)0, (int)gravity3D.getGroup().numChildren());
        MockMobile mobile = new MockMobile();
        gravity3D.fall((Mobile)mobile);
        BasicGravity3DTest.assertEquals((int)1, (int)gravity3D.getGroup().numChildren());
        gravity3D.isFallen((Mobile)mobile);
        BasicGravity3DTest.assertEquals((int)0, (int)gravity3D.getGroup().numChildren());
    }
}

