/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.tree;

import barsuift.simLife.Randomizer;
import barsuift.simLife.j3d.Axis;
import barsuift.simLife.j3d.Tuple3dState;
import barsuift.simLife.j3d.helper.PointTestHelper;
import barsuift.simLife.j3d.tree.TreeLeaf3DState;
import barsuift.simLife.j3d.tree.TreeLeaf3DStateFactory;
import barsuift.simLife.j3d.util.TransformerHelper;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import junit.framework.TestCase;

public class TreeLeaf3DStateFactoryTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreateRandomTreeLeaf3DState() {
        TreeLeaf3DStateFactory factory = new TreeLeaf3DStateFactory();
        Point3d leafAttachPoint = new Point3d(0.32, 0.33, 0.34);
        double rotation = Randomizer.randomRotation();
        Transform3D transform = TransformerHelper.getTranslationTransform3D((Vector3d)new Vector3d((Tuple3d)leafAttachPoint));
        Transform3D rotationT3D = TransformerHelper.getRotationTransform3D((double)rotation, (Axis)Axis.Y);
        transform.mul(rotationT3D);
        TreeLeaf3DState leaf3DState = factory.createRandomTreeLeaf3DState(transform);
        Transform3D actualTransform = leaf3DState.getTransform().toTransform3D();
        Tuple3dState actualInitialEndPoint1 = leaf3DState.getInitialEndPoint1();
        Tuple3dState actualInitialEndPoint2 = leaf3DState.getInitialEndPoint2();
        Tuple3dState actualEndPoint1 = leaf3DState.getEndPoint1();
        Tuple3dState actualEndPoint2 = leaf3DState.getEndPoint2();
        Vector3d actualTranslation = new Vector3d();
        actualTransform.get(actualTranslation);
        double actualRotation = TransformerHelper.getRotationFromTransform((Transform3D)actualTransform, (Axis)Axis.Y);
        TreeLeaf3DStateFactoryTest.assertEquals((Object)leafAttachPoint, (Object)new Point3d((Tuple3d)actualTranslation));
        TreeLeaf3DStateFactoryTest.assertEquals((double)rotation, (double)actualRotation, (double)1.0E-6);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong X position for end point 1.", (actualInitialEndPoint1.getX() > -0.03 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong X position for end point 1.", (actualInitialEndPoint1.getX() < -0.01 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Y position for end point 1.", (actualInitialEndPoint1.getY() > -0.05 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Y position for end point 1.", (actualInitialEndPoint1.getY() < -0.03 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Z position for end point 1.", (actualInitialEndPoint1.getZ() > -0.01 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Z position for end point 1.", (actualInitialEndPoint1.getZ() < 0.01 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong X position for end point 2.", (actualInitialEndPoint2.getX() > 0.01 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong X position for end point 2.", (actualInitialEndPoint2.getX() < 0.03 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Y position for end point 2.", (actualInitialEndPoint2.getY() > -0.05 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Y position for end point 2.", (actualInitialEndPoint2.getY() < -0.03 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Z position for end point 2.", (actualInitialEndPoint2.getZ() > -0.01 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Z position for end point 2.", (actualInitialEndPoint2.getZ() < 0.01 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong X position for end point 1.", (actualEndPoint1.getX() > -0.30000000000000004 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong X position for end point 1.", (actualEndPoint1.getX() < -0.1 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Y position for end point 1.", (actualEndPoint1.getY() > -0.5 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Y position for end point 1.", (actualEndPoint1.getY() < -0.30000000000000004 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Z position for end point 1.", (actualEndPoint1.getZ() > -0.1 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Z position for end point 1.", (actualEndPoint1.getZ() < 0.1 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong X position for end point 2.", (actualEndPoint2.getX() > 0.1 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong X position for end point 2.", (actualEndPoint2.getX() < 0.30000000000000004 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Y position for end point 2.", (actualEndPoint2.getY() > -0.5 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Y position for end point 2.", (actualEndPoint2.getY() < -0.30000000000000004 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Z position for end point 2.", (actualEndPoint2.getZ() > -0.1 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Z position for end point 2.", (actualEndPoint2.getZ() < 0.1 ? 1 : 0) != 0);
    }

    public void testCreateNewTreeLeaf3DState() {
        TreeLeaf3DStateFactory factory = new TreeLeaf3DStateFactory();
        Point3d leafAttachPoint = new Point3d(0.32, 0.33, 0.34);
        double rotation = Randomizer.randomRotation();
        Transform3D transform = TransformerHelper.getTranslationTransform3D((Vector3d)new Vector3d((Tuple3d)leafAttachPoint));
        Transform3D rotationT3D = TransformerHelper.getRotationTransform3D((double)rotation, (Axis)Axis.Y);
        transform.mul(rotationT3D);
        TreeLeaf3DState leaf3DState = factory.createNewTreeLeaf3DState(transform);
        Transform3D actualTransform = leaf3DState.getTransform().toTransform3D();
        Tuple3dState actualInitialEndPoint1 = leaf3DState.getInitialEndPoint1();
        Tuple3dState actualInitialEndPoint2 = leaf3DState.getInitialEndPoint2();
        Tuple3dState actualEndPoint1 = leaf3DState.getEndPoint1();
        Tuple3dState actualEndPoint2 = leaf3DState.getEndPoint2();
        Vector3d actualTranslation = new Vector3d();
        actualTransform.get(actualTranslation);
        double actualRotation = TransformerHelper.getRotationFromTransform((Transform3D)actualTransform, (Axis)Axis.Y);
        TreeLeaf3DStateFactoryTest.assertEquals((Object)leafAttachPoint, (Object)new Point3d((Tuple3d)actualTranslation));
        TreeLeaf3DStateFactoryTest.assertEquals((double)rotation, (double)actualRotation, (double)1.0E-6);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong X position for end point 1.", (actualInitialEndPoint1.getX() > -0.03 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong X position for end point 1.", (actualInitialEndPoint1.getX() < -0.01 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Y position for end point 1.", (actualInitialEndPoint1.getY() > -0.05 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Y position for end point 1.", (actualInitialEndPoint1.getY() < -0.03 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Z position for end point 1.", (actualInitialEndPoint1.getZ() > -0.01 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Z position for end point 1.", (actualInitialEndPoint1.getZ() < 0.01 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong X position for end point 2.", (actualInitialEndPoint2.getX() > 0.01 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong X position for end point 2.", (actualInitialEndPoint2.getX() < 0.03 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Y position for end point 2.", (actualInitialEndPoint2.getY() > -0.05 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Y position for end point 2.", (actualInitialEndPoint2.getY() < -0.03 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Z position for end point 2.", (actualInitialEndPoint2.getZ() > -0.01 ? 1 : 0) != 0);
        TreeLeaf3DStateFactoryTest.assertTrue((String)"Wrong Z position for end point 2.", (actualInitialEndPoint2.getZ() < 0.01 ? 1 : 0) != 0);
        PointTestHelper.assertPointEquals(actualInitialEndPoint1.toPointValue(), actualEndPoint1.toPointValue());
        PointTestHelper.assertPointEquals(actualInitialEndPoint2.toPointValue(), actualEndPoint2.toPointValue());
    }
}

