/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.tree;

import barsuift.simLife.PercentHelper;
import barsuift.simLife.Randomizer;
import barsuift.simLife.j3d.Axis;
import barsuift.simLife.j3d.DisplayDataCreatorForTests;
import barsuift.simLife.j3d.MobileEvent;
import barsuift.simLife.j3d.Transform3DState;
import barsuift.simLife.j3d.Tuple3dState;
import barsuift.simLife.j3d.helper.ColorTestHelper;
import barsuift.simLife.j3d.helper.CompilerHelper;
import barsuift.simLife.j3d.helper.PointTestHelper;
import barsuift.simLife.j3d.helper.Structure3DHelper;
import barsuift.simLife.j3d.tree.BasicTreeLeaf3D;
import barsuift.simLife.j3d.tree.TreeLeaf3DState;
import barsuift.simLife.j3d.universe.MockUniverse3D;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.j3d.util.ColorConstants;
import barsuift.simLife.j3d.util.TransformerHelper;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import barsuift.simLife.tree.LeafEvent;
import barsuift.simLife.tree.MockTreeLeaf;
import barsuift.simLife.tree.TreeLeaf;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import junit.framework.TestCase;

public class BasicTreeLeaf3DTest
extends TestCase {
    private MockTreeLeaf mockLeaf;
    private TreeLeaf3DState leaf3DState;
    private MockUniverse3D mockUniverse3D;

    protected void setUp() throws Exception {
        super.setUp();
        this.mockLeaf = new MockTreeLeaf();
        this.leaf3DState = DisplayDataCreatorForTests.createRandomTreeLeaf3DState();
        this.mockUniverse3D = new MockUniverse3D();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.mockLeaf = null;
        this.leaf3DState = null;
        this.mockUniverse3D = null;
    }

    public void testConstructor() {
        try {
            new BasicTreeLeaf3D((Universe3D)this.mockUniverse3D, null, (TreeLeaf)this.mockLeaf);
            BasicTreeLeaf3DTest.fail((String)"Should throw new IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTreeLeaf3D((Universe3D)this.mockUniverse3D, this.leaf3DState, null);
            BasicTreeLeaf3DTest.fail((String)"Should throw new IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTreeLeaf3D(null, this.leaf3DState, (TreeLeaf)this.mockLeaf);
            BasicTreeLeaf3DTest.fail((String)"Should throw new IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetState() {
        this.leaf3DState = DisplayDataCreatorForTests.createSpecificTreeLeaf3DState();
        BasicTreeLeaf3D leaf3D = new BasicTreeLeaf3D((Universe3D)this.mockUniverse3D, this.leaf3DState, (TreeLeaf)this.mockLeaf);
        BasicTreeLeaf3DTest.assertEquals((Object)this.leaf3DState, (Object)leaf3D.getState());
        BasicTreeLeaf3DTest.assertEquals((Object)this.leaf3DState, (Object)leaf3D.getState());
        BasicTreeLeaf3DTest.assertSame((Object)this.leaf3DState, (Object)leaf3D.getState());
        BasicTreeLeaf3DTest.assertEquals((double)0.4, (double)leaf3D.getState().getEndPoint1().getX(), (double)1.0E-5);
        BasicTreeLeaf3DTest.assertEquals((double)0.0, (double)leaf3D.getState().getEndPoint1().getY(), (double)1.0E-5);
        BasicTreeLeaf3DTest.assertEquals((double)0.0, (double)leaf3D.getState().getEndPoint1().getZ(), (double)1.0E-5);
        leaf3D.increaseSize();
        BasicTreeLeaf3DTest.assertEquals((Object)this.leaf3DState, (Object)leaf3D.getState());
        BasicTreeLeaf3DTest.assertSame((Object)this.leaf3DState, (Object)leaf3D.getState());
        BasicTreeLeaf3DTest.assertEquals((double)0.6, (double)leaf3D.getState().getEndPoint1().getX(), (double)1.0E-5);
        BasicTreeLeaf3DTest.assertEquals((double)0.2, (double)leaf3D.getState().getEndPoint1().getY(), (double)1.0E-5);
        BasicTreeLeaf3DTest.assertEquals((double)0.0, (double)leaf3D.getState().getEndPoint1().getZ(), (double)1.0E-5);
    }

    public void testSubscribers() {
        this.mockLeaf.setEfficiency(PercentHelper.getDecimalValue((int)80));
        BasicTreeLeaf3D leaf3D = new BasicTreeLeaf3D((Universe3D)this.mockUniverse3D, this.leaf3DState, (TreeLeaf)this.mockLeaf);
        BasicTreeLeaf3DTest.assertEquals((int)1, (int)this.mockLeaf.countSubscribers());
        this.mockLeaf.deleteSubscriber((Subscriber)leaf3D);
        BasicTreeLeaf3DTest.assertEquals((int)0, (int)this.mockLeaf.countSubscribers());
    }

    public void testAppearance() {
        this.mockLeaf.setEfficiency(PercentHelper.getDecimalValue((int)80));
        BasicTreeLeaf3D leaf3D = new BasicTreeLeaf3D((Universe3D)this.mockUniverse3D, this.leaf3DState, (TreeLeaf)this.mockLeaf);
        CompilerHelper.compile((Group)leaf3D.getBranchGroup());
        Shape3D leafShape3D = (Shape3D)((TransformGroup)leaf3D.getBranchGroup().getChild(0)).getChild(0);
        Color3f expectedColor = new Color3f(ColorConstants.brownYellow);
        expectedColor.interpolate((Tuple3f)ColorConstants.green, 0.8f);
        ColorTestHelper.testColorFromMaterial(leafShape3D.getAppearance(), expectedColor, new Color3f(0.05f, 0.05f, 0.05f), new Color3f(0.15f, 0.15f, 0.15f));
        BasicTreeLeaf3DTest.assertEquals((int)0, (int)leafShape3D.getAppearance().getPolygonAttributes().getCullFace());
        this.mockLeaf.setEfficiency(PercentHelper.getDecimalValue((int)75));
        leaf3D.update((Publisher)this.mockLeaf, (Object)LeafEvent.EFFICIENCY);
        expectedColor = new Color3f(ColorConstants.brownYellow);
        expectedColor.interpolate((Tuple3f)ColorConstants.green, 0.75f);
        ColorTestHelper.testColorFromMaterial(leafShape3D.getAppearance(), expectedColor, new Color3f(0.05f, 0.05f, 0.05f), new Color3f(0.15f, 0.15f, 0.15f));
        this.mockLeaf.setEfficiency(PercentHelper.getDecimalValue((int)60));
        leaf3D.update((Publisher)this.mockLeaf, (Object)65536);
        expectedColor = new Color3f(ColorConstants.brownYellow);
        expectedColor.interpolate((Tuple3f)ColorConstants.green, 0.75f);
        ColorTestHelper.testColorFromMaterial(leafShape3D.getAppearance(), expectedColor, new Color3f(0.05f, 0.05f, 0.05f), new Color3f(0.15f, 0.15f, 0.15f));
    }

    public void testGeometry() {
        BasicTreeLeaf3D leaf3D = new BasicTreeLeaf3D((Universe3D)this.mockUniverse3D, this.leaf3DState, (TreeLeaf)this.mockLeaf);
        BranchGroup bg = leaf3D.getBranchGroup();
        CompilerHelper.compile((Group)bg);
        Structure3DHelper.assertExactlyOneTransformGroup(bg);
        TransformGroup transformGroup = (TransformGroup)bg.getChild(0);
        Transform3D transform3D = new Transform3D();
        transformGroup.getTransform(transform3D);
        BasicTreeLeaf3DTest.assertEquals((Object)this.leaf3DState.getTransform(), (Object)new Transform3DState(transform3D));
        Structure3DHelper.assertExactlyOneShape3D(transformGroup);
        Shape3D leafShape3D = (Shape3D)transformGroup.getChild(0);
        BasicTreeLeaf3DTest.assertNotNull((Object)leafShape3D);
        Geometry leafGeometry = leafShape3D.getGeometry();
        BasicTreeLeaf3DTest.assertTrue((boolean)(leafGeometry instanceof TriangleArray));
        TriangleArray leafTriangle = (TriangleArray)leafGeometry;
        BasicTreeLeaf3DTest.assertEquals((int)3, (int)leafTriangle.getVertexCount());
        Point3d actualStartPoint = new Point3d();
        Point3d actualEndPoint1 = new Point3d();
        Point3d actualEndPoint2 = new Point3d();
        leafTriangle.getCoordinate(0, actualStartPoint);
        leafTriangle.getCoordinate(1, actualEndPoint1);
        leafTriangle.getCoordinate(2, actualEndPoint2);
        PointTestHelper.assertPointEquals(new Point3d(0.0, 0.0, 0.0), actualStartPoint);
        PointTestHelper.assertPointEquals(this.leaf3DState.getEndPoint1().toPointValue(), actualEndPoint1);
        PointTestHelper.assertPointEquals(this.leaf3DState.getEndPoint2().toPointValue(), actualEndPoint2);
    }

    public void testFall() {
        double initialRotation = Randomizer.randomRotation();
        Tuple3dState initialLeafAttachPoint = new Tuple3dState(1.0, 2.0, 3.0);
        Transform3D initialTransform = TransformerHelper.getTranslationTransform3D((Vector3d)initialLeafAttachPoint.toVectorValue());
        Transform3D initialRotationT3D = TransformerHelper.getRotationTransform3D((double)initialRotation, (Axis)Axis.Y);
        initialTransform.mul(initialRotationT3D);
        this.leaf3DState.setTransform(new Transform3DState(initialTransform));
        BasicTreeLeaf3D leaf3D = new BasicTreeLeaf3D((Universe3D)this.mockUniverse3D, this.leaf3DState, (TreeLeaf)this.mockLeaf);
        Transform3D parentTransform3D = new Transform3D();
        Vector3d parentTranslation = new Vector3d(2.0, 3.0, 5.0);
        parentTransform3D.set(parentTranslation);
        Transform3D parentRotation = new Transform3D();
        parentRotation.rotY(1.5707963267948966);
        parentTransform3D.mul(parentRotation);
        TransformGroup parentTransformGroup = new TransformGroup(parentTransform3D);
        BranchGroup parentBranchGroup = new BranchGroup();
        parentTransformGroup.setCapability(13);
        parentBranchGroup.addChild((Node)parentTransformGroup);
        parentTransformGroup.addChild((Node)leaf3D.getBranchGroup());
        CompilerHelper.addToLocale(parentBranchGroup);
        leaf3D.update(null, (Object)MobileEvent.FALLING);
        BasicTreeLeaf3DTest.assertEquals((Object)new Point3d(5.0, 5.0, 4.0), (Object)leaf3D.getPosition());
        TransformGroup tg = (TransformGroup)leaf3D.getBranchGroup().getChild(0);
        Transform3D newTransform = new Transform3D();
        tg.getTransform(newTransform);
        double newRotation = TransformerHelper.getRotationFromTransform((Transform3D)newTransform, (Axis)Axis.Y);
        BasicTreeLeaf3DTest.assertEquals((double)((initialRotation + 1.5707963267948966) % (Math.PI * 2)), (double)newRotation, (double)1.0E-6);
    }

    public void testGetArea() {
        this.leaf3DState = DisplayDataCreatorForTests.createSpecificTreeLeaf3DState();
        BasicTreeLeaf3D leaf3D = new BasicTreeLeaf3D((Universe3D)this.mockUniverse3D, this.leaf3DState, (TreeLeaf)this.mockLeaf);
        BasicTreeLeaf3DTest.assertEquals((double)0.08, (double)leaf3D.getArea(), (double)1.0E-6);
    }

    public void testIsMaxSizeReached() {
        this.leaf3DState = DisplayDataCreatorForTests.createSpecificTreeLeaf3DState();
        BasicTreeLeaf3D leaf3D = new BasicTreeLeaf3D((Universe3D)this.mockUniverse3D, this.leaf3DState, (TreeLeaf)this.mockLeaf);
        BasicTreeLeaf3DTest.assertFalse((boolean)leaf3D.isMaxSizeReached());
        Tuple3dState initialEndPoint1 = this.leaf3DState.getInitialEndPoint1();
        this.leaf3DState.setEndPoint1(new Tuple3dState(10.0 * initialEndPoint1.getX(), 10.0 * initialEndPoint1.getY(), 10.0 * initialEndPoint1.getZ()));
        Tuple3dState initialEndPoint2 = this.leaf3DState.getInitialEndPoint2();
        this.leaf3DState.setEndPoint2(new Tuple3dState(10.0 * initialEndPoint2.getX(), 10.0 * initialEndPoint2.getY(), 10.0 * initialEndPoint2.getZ()));
        leaf3D = new BasicTreeLeaf3D((Universe3D)this.mockUniverse3D, this.leaf3DState, (TreeLeaf)this.mockLeaf);
        BasicTreeLeaf3DTest.assertTrue((boolean)leaf3D.isMaxSizeReached());
    }

    public void testIncreaseSize() {
        this.leaf3DState = DisplayDataCreatorForTests.createSpecificTreeLeaf3DState();
        this.leaf3DState.setEndPoint1(this.leaf3DState.getInitialEndPoint1());
        this.leaf3DState.setEndPoint2(this.leaf3DState.getInitialEndPoint2());
        Tuple3dState initialEndPoint1 = this.leaf3DState.getInitialEndPoint1();
        Tuple3dState initialEndPoint2 = this.leaf3DState.getInitialEndPoint2();
        BasicTreeLeaf3D leaf3D = new BasicTreeLeaf3D((Universe3D)this.mockUniverse3D, this.leaf3DState, (TreeLeaf)this.mockLeaf);
        Shape3D leafShape = (Shape3D)((TransformGroup)leaf3D.getBranchGroup().getChild(0)).getChild(0);
        Point3d geomEndPoint1 = new Point3d();
        Point3d geomEndPoint2 = new Point3d();
        BasicTreeLeaf3DTest.assertFalse((boolean)leaf3D.isMaxSizeReached());
        leaf3D.increaseSize();
        Point3d endPoint1 = leaf3D.getState().getEndPoint1().toPointValue();
        Point3d expectedEndPoint1 = new Point3d(initialEndPoint1.getX() * 2.0, initialEndPoint1.getY() * 2.0, initialEndPoint1.getZ() * 2.0);
        PointTestHelper.assertPointEquals(expectedEndPoint1, endPoint1);
        Point3d endPoint2 = leaf3D.getState().getEndPoint2().toPointValue();
        Point3d expectedEndPoint2 = new Point3d(initialEndPoint2.getX() * 2.0, initialEndPoint2.getY() * 2.0, initialEndPoint2.getZ() * 2.0);
        PointTestHelper.assertPointEquals(expectedEndPoint2, endPoint2);
        ((TriangleArray)leafShape.getGeometry()).getCoordinate(1, geomEndPoint1);
        PointTestHelper.assertPointEquals(leaf3D.getState().getEndPoint1().toPointValue(), geomEndPoint1);
        ((TriangleArray)leafShape.getGeometry()).getCoordinate(1, geomEndPoint2);
        PointTestHelper.assertPointEquals(leaf3D.getState().getEndPoint1().toPointValue(), geomEndPoint2);
        leaf3D.increaseSize();
        endPoint1 = leaf3D.getState().getEndPoint1().toPointValue();
        expectedEndPoint1 = new Point3d(initialEndPoint1.getX() * 3.0, initialEndPoint1.getY() * 3.0, initialEndPoint1.getZ() * 3.0);
        PointTestHelper.assertPointEquals(expectedEndPoint1, endPoint1);
        endPoint2 = leaf3D.getState().getEndPoint2().toPointValue();
        expectedEndPoint2 = new Point3d(initialEndPoint2.getX() * 3.0, initialEndPoint2.getY() * 3.0, initialEndPoint2.getZ() * 3.0);
        PointTestHelper.assertPointEquals(expectedEndPoint2, endPoint2);
        ((TriangleArray)leafShape.getGeometry()).getCoordinate(1, geomEndPoint1);
        PointTestHelper.assertPointEquals(leaf3D.getState().getEndPoint1().toPointValue(), geomEndPoint1);
        ((TriangleArray)leafShape.getGeometry()).getCoordinate(1, geomEndPoint2);
        PointTestHelper.assertPointEquals(leaf3D.getState().getEndPoint1().toPointValue(), geomEndPoint2);
        leaf3D.increaseSize();
        leaf3D.increaseSize();
        leaf3D.increaseSize();
        leaf3D.increaseSize();
        leaf3D.increaseSize();
        leaf3D.increaseSize();
        leaf3D.increaseSize();
        BasicTreeLeaf3DTest.assertTrue((boolean)leaf3D.isMaxSizeReached());
        endPoint1 = leaf3D.getState().getEndPoint1().toPointValue();
        expectedEndPoint1 = new Point3d(initialEndPoint1.getX() * 10.0, initialEndPoint1.getY() * 10.0, initialEndPoint1.getZ() * 10.0);
        PointTestHelper.assertPointEquals(expectedEndPoint1, endPoint1);
        endPoint2 = leaf3D.getState().getEndPoint2().toPointValue();
        expectedEndPoint2 = new Point3d(initialEndPoint2.getX() * 10.0, initialEndPoint2.getY() * 10.0, initialEndPoint2.getZ() * 10.0);
        PointTestHelper.assertPointEquals(expectedEndPoint2, endPoint2);
        ((TriangleArray)leafShape.getGeometry()).getCoordinate(1, geomEndPoint1);
        PointTestHelper.assertPointEquals(leaf3D.getState().getEndPoint1().toPointValue(), geomEndPoint1);
        ((TriangleArray)leafShape.getGeometry()).getCoordinate(1, geomEndPoint2);
        PointTestHelper.assertPointEquals(leaf3D.getState().getEndPoint1().toPointValue(), geomEndPoint2);
        leaf3D.increaseSize();
        BasicTreeLeaf3DTest.assertTrue((boolean)leaf3D.isMaxSizeReached());
        endPoint1 = leaf3D.getState().getEndPoint1().toPointValue();
        expectedEndPoint1 = new Point3d(initialEndPoint1.getX() * 10.0, initialEndPoint1.getY() * 10.0, initialEndPoint1.getZ() * 10.0);
        PointTestHelper.assertPointEquals(expectedEndPoint1, endPoint1);
        endPoint2 = leaf3D.getState().getEndPoint2().toPointValue();
        expectedEndPoint2 = new Point3d(initialEndPoint2.getX() * 10.0, initialEndPoint2.getY() * 10.0, initialEndPoint2.getZ() * 10.0);
        PointTestHelper.assertPointEquals(expectedEndPoint2, endPoint2);
        ((TriangleArray)leafShape.getGeometry()).getCoordinate(1, geomEndPoint1);
        PointTestHelper.assertPointEquals(leaf3D.getState().getEndPoint1().toPointValue(), geomEndPoint1);
        ((TriangleArray)leafShape.getGeometry()).getCoordinate(1, geomEndPoint2);
        PointTestHelper.assertPointEquals(leaf3D.getState().getEndPoint1().toPointValue(), geomEndPoint2);
    }
}

