/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.tree;

import barsuift.simLife.j3d.DisplayDataCreatorForTests;
import barsuift.simLife.j3d.helper.CompilerHelper;
import barsuift.simLife.j3d.tree.BasicTreeBranchPart3D;
import barsuift.simLife.j3d.tree.TreeBranchPart3DState;
import barsuift.simLife.j3d.tree.TreeLeaf3DState;
import barsuift.simLife.j3d.tree.helper.BasicTreeBranchPart3DTestHelper;
import barsuift.simLife.j3d.universe.MockUniverse3D;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.tree.MockTreeBranchPart;
import barsuift.simLife.tree.MockTreeLeaf;
import barsuift.simLife.tree.TreeBranchPart;
import barsuift.simLife.tree.TreeLeaf;
import java.util.Enumeration;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3d;
import junit.framework.TestCase;

public class BasicTreeBranchPart3DTest
extends TestCase {
    private int nbLeaves;
    private MockUniverse3D mockUniverse3D;
    private MockTreeBranchPart mockBranchPart;
    private TreeBranchPart3DState part3DState;

    protected void setUp() throws Exception {
        super.setUp();
        this.mockBranchPart = new MockTreeBranchPart();
        this.nbLeaves = 5;
        for (int index = 0; index < this.nbLeaves; ++index) {
            MockTreeLeaf mockLeaf = new MockTreeLeaf();
            ((TreeLeaf3DState)mockLeaf.getTreeLeaf3D().getState()).setTransform(DisplayDataCreatorForTests.createRandomTransform3DState());
            this.mockBranchPart.addLeaf((TreeLeaf)mockLeaf);
        }
        this.mockUniverse3D = new MockUniverse3D();
        this.part3DState = DisplayDataCreatorForTests.createRandomTreeBranchPart3DState();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.nbLeaves = 0;
        this.mockUniverse3D = null;
        this.mockBranchPart = null;
        this.part3DState = null;
    }

    public void testConstructor() {
        try {
            new BasicTreeBranchPart3D((Universe3D)this.mockUniverse3D, null, (TreeBranchPart)this.mockBranchPart);
            BasicTreeBranchPart3DTest.fail((String)"Should throw new IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTreeBranchPart3D((Universe3D)this.mockUniverse3D, this.part3DState, null);
            BasicTreeBranchPart3DTest.fail((String)"Should throw new IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTreeBranchPart3D(null, this.part3DState, (TreeBranchPart)this.mockBranchPart);
            BasicTreeBranchPart3DTest.fail((String)"Should throw new IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetState() {
        BasicTreeBranchPart3D part3D = new BasicTreeBranchPart3D((Universe3D)this.mockUniverse3D, this.part3DState, (TreeBranchPart)this.mockBranchPart);
        BasicTreeBranchPart3DTest.assertEquals((Object)this.part3DState, (Object)part3D.getState());
        BasicTreeBranchPart3DTest.assertSame((Object)this.part3DState, (Object)part3D.getState());
    }

    public void testTreeBranchPart3D() {
        BasicTreeBranchPart3D part3D = new BasicTreeBranchPart3D((Universe3D)this.mockUniverse3D, this.part3DState, (TreeBranchPart)this.mockBranchPart);
        CompilerHelper.compile(part3D.getGroup());
        BasicTreeBranchPart3DTest.assertEquals((int)this.nbLeaves, (int)part3D.getLeaves().size());
        BasicTreeBranchPart3DTest.assertEquals((Object)this.part3DState.getEndPoint().toPointValue(), (Object)part3D.getEndPoint());
        Group partGroup = part3D.getGroup();
        BasicTreeBranchPart3DTest.assertTrue((boolean)partGroup.getCapability(13));
        BasicTreeBranchPart3DTest.assertTrue((boolean)partGroup.getCapability(14));
        int nbTimesNoLeafShapeIsFound = 0;
        int nbLeavesFound = 0;
        Enumeration enumeration = partGroup.getAllChildren();
        while (enumeration.hasMoreElements()) {
            Object child = enumeration.nextElement();
            if (child instanceof BranchGroup) {
                ++nbLeavesFound;
                continue;
            }
            if (child instanceof Shape3D) {
                BasicTreeBranchPart3DTest.assertEquals((String)"We should have only one shape (the branch part)", (int)1, (int)(++nbTimesNoLeafShapeIsFound));
                Shape3D branchScape = (Shape3D)child;
                BasicTreeBranchPart3DTestHelper.testGeometry(branchScape.getGeometry(), new Point3d(0.0, 0.0, 0.0), this.part3DState.getEndPoint().toPointValue());
                BasicTreeBranchPart3DTestHelper.testAppearance(branchScape.getAppearance());
                continue;
            }
            BasicTreeBranchPart3DTest.fail((String)("There should be no other children. child is instance of " + child.getClass()));
        }
        BasicTreeBranchPart3DTest.assertEquals((int)this.nbLeaves, (int)nbLeavesFound);
    }
}

