/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.environment;

import barsuift.simLife.PercentHelper;
import barsuift.simLife.environment.MockSun;
import barsuift.simLife.environment.Sun;
import barsuift.simLife.environment.SunUpdateCode;
import barsuift.simLife.j3d.environment.BasicSun3D;
import barsuift.simLife.j3d.helper.CompilerHelper;
import barsuift.simLife.j3d.helper.VectorTestHelper;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.PublisherTestHelper;
import barsuift.simLife.message.Subscriber;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Light;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;
import junit.framework.TestCase;

public class BasicSun3DTest
extends TestCase {
    private MockSun mockSun;
    private BasicSun3D sun3D;
    private DirectionalLight sunLight;
    private PublisherTestHelper publisherHelper;

    protected void setUp() throws Exception {
        super.setUp();
        this.mockSun = new MockSun();
        this.sun3D = new BasicSun3D((Sun)this.mockSun);
        this.sunLight = this.sun3D.getLight();
        CompilerHelper.compile((Light)this.sunLight);
        this.publisherHelper = new PublisherTestHelper();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.mockSun = null;
        this.sun3D = null;
        this.sunLight = null;
        this.publisherHelper = null;
    }

    public void testSubscribers() {
        BasicSun3DTest.assertEquals((int)1, (int)this.mockSun.countSubscribers());
        this.mockSun.deleteSubscriber((Subscriber)this.sun3D);
        BasicSun3DTest.assertEquals((int)0, (int)this.mockSun.countSubscribers());
    }

    public void testPublisher() {
        this.publisherHelper.addSubscriberTo((Publisher)this.sun3D);
        this.mockSun.setZenithAngle(PercentHelper.getDecimalValue((int)100));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.zenithAngle);
        BasicSun3DTest.assertEquals((int)1, (int)this.publisherHelper.nbUpdated());
        BasicSun3DTest.assertEquals((Object)SunUpdateCode.color, this.publisherHelper.getUpdateObjects().get(0));
    }

    public void testUpdateBrightness() {
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)50));
        this.mockSun.setZenithAngle(PercentHelper.getDecimalValue((int)100));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.zenithAngle);
        Color3f actualSunColor = new Color3f();
        this.sunLight.getColor(actualSunColor);
        BasicSun3DTest.assertEquals((Object)new Color3f(1.0f, 1.0f, 1.0f), (Object)actualSunColor);
        this.mockSun.setBrightness(PercentHelper.getDecimalValue((int)40));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.brightness);
        actualSunColor = new Color3f();
        this.sunLight.getColor(actualSunColor);
        BasicSun3DTest.assertEquals((Object)new Color3f(0.4f, 0.4f, 0.4f), (Object)actualSunColor);
        this.mockSun.setBrightness(PercentHelper.getDecimalValue((int)70));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.brightness);
        actualSunColor = new Color3f();
        this.sunLight.getColor(actualSunColor);
        BasicSun3DTest.assertEquals((Object)new Color3f(0.7f, 0.7f, 0.7f), (Object)actualSunColor);
    }

    public void testUpdateColor() {
        Color3f actualSunColor = new Color3f();
        this.sunLight.getColor(actualSunColor);
        BasicSun3DTest.assertEquals((Object)new Color3f(1.0f, (float)Math.sqrt(2.0) / 2.0f, (float)Math.sqrt(2.0) / 2.0f), (Object)actualSunColor);
        this.mockSun.setBrightness(PercentHelper.getDecimalValue((int)50));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.brightness);
        actualSunColor = new Color3f();
        this.sunLight.getColor(actualSunColor);
        BasicSun3DTest.assertEquals((Object)new Color3f(0.5f, (float)(0.5 * Math.sqrt(2.0) / 2.0), (float)(0.5 * Math.sqrt(2.0) / 2.0)), (Object)actualSunColor);
        this.mockSun.setBrightness(PercentHelper.getDecimalValue((int)100));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.brightness);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)0));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        actualSunColor = new Color3f();
        this.sunLight.getColor(actualSunColor);
        BasicSun3DTest.assertEquals((Object)new Color3f(1.0f, 0.0f, 0.0f), (Object)actualSunColor);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)50));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        actualSunColor = new Color3f();
        this.sunLight.getColor(actualSunColor);
        BasicSun3DTest.assertEquals((Object)new Color3f(1.0f, (float)Math.sqrt(Math.sqrt(2.0) / 2.0), (float)Math.sqrt(Math.sqrt(2.0) / 2.0)), (Object)actualSunColor);
        this.mockSun.setZenithAngle(PercentHelper.getDecimalValue((int)100));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.zenithAngle);
        actualSunColor = new Color3f();
        this.sunLight.getColor(actualSunColor);
        BasicSun3DTest.assertEquals((Object)new Color3f(1.0f, 1.0f, 1.0f), (Object)actualSunColor);
    }

    public void testUpdateRiseAngle1() {
        BasicSun3DTest.assertEquals((Object)PercentHelper.getDecimalValue((int)25), (Object)this.mockSun.getRiseAngle());
        BasicSun3DTest.assertEquals((Object)PercentHelper.getDecimalValue((int)50), (Object)this.mockSun.getZenithAngle());
        Vector3f actualDirection = new Vector3f();
        this.sunLight.getDirection(actualDirection);
        Vector3f expectedDirection = new Vector3f((float)Math.sqrt(2.0) / 2.0f, -0.5f, -0.5f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)0));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        this.sunLight.getDirection(actualDirection);
        expectedDirection = new Vector3f(1.0f, 0.0f, 0.0f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)50));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        this.sunLight.getDirection(actualDirection);
        expectedDirection = new Vector3f(0.0f, -((float)Math.sqrt(2.0)) / 2.0f, -((float)Math.sqrt(2.0)) / 2.0f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)75));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        this.sunLight.getDirection(actualDirection);
        expectedDirection = new Vector3f(-((float)Math.sqrt(2.0)) / 2.0f, -0.5f, -0.5f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)100));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        this.sunLight.getDirection(actualDirection);
        expectedDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
    }

    public void testUpdateRiseAngle2() {
        this.mockSun.setZenithAngle(PercentHelper.getDecimalValue((int)0));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.zenithAngle);
        BasicSun3DTest.assertEquals((Object)PercentHelper.getDecimalValue((int)25), (Object)this.mockSun.getRiseAngle());
        Vector3f actualDirection = new Vector3f();
        this.sunLight.getDirection(actualDirection);
        Vector3f expectedDirection = new Vector3f((float)Math.sqrt(2.0) / 2.0f, 0.0f, (float)(-Math.sqrt(2.0)) / 2.0f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)0));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        this.sunLight.getDirection(actualDirection);
        expectedDirection = new Vector3f(1.0f, 0.0f, 0.0f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)50));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        this.sunLight.getDirection(actualDirection);
        expectedDirection = new Vector3f(0.0f, 0.0f, -1.0f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)75));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        this.sunLight.getDirection(actualDirection);
        expectedDirection = new Vector3f(-((float)Math.sqrt(2.0)) / 2.0f, 0.0f, -((float)Math.sqrt(2.0)) / 2.0f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)100));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        this.sunLight.getDirection(actualDirection);
        expectedDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
    }

    public void testUpdateRiseAngle3() {
        this.mockSun.setZenithAngle(PercentHelper.getDecimalValue((int)100));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.zenithAngle);
        BasicSun3DTest.assertEquals((Object)PercentHelper.getDecimalValue((int)25), (Object)this.mockSun.getRiseAngle());
        Vector3f actualDirection = new Vector3f();
        this.sunLight.getDirection(actualDirection);
        Vector3f expectedDirection = new Vector3f((float)Math.sqrt(2.0) / 2.0f, -((float)Math.sqrt(2.0)) / 2.0f, 0.0f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)0));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        this.sunLight.getDirection(actualDirection);
        expectedDirection = new Vector3f(1.0f, 0.0f, 0.0f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)50));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        this.sunLight.getDirection(actualDirection);
        expectedDirection = new Vector3f(0.0f, -1.0f, 0.0f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)75));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        this.sunLight.getDirection(actualDirection);
        expectedDirection = new Vector3f(-((float)Math.sqrt(2.0)) / 2.0f, -((float)Math.sqrt(2.0)) / 2.0f, 0.0f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)100));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        this.sunLight.getDirection(actualDirection);
        expectedDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
    }

    public void testUpdateZenithAngle() {
        BasicSun3DTest.assertEquals((Object)PercentHelper.getDecimalValue((int)25), (Object)this.mockSun.getRiseAngle());
        BasicSun3DTest.assertEquals((Object)PercentHelper.getDecimalValue((int)50), (Object)this.mockSun.getZenithAngle());
        Vector3f actualDirection = new Vector3f();
        this.sunLight.getDirection(actualDirection);
        Vector3f expectedDirection = new Vector3f((float)Math.sqrt(2.0) / 2.0f, -0.5f, -0.5f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
        this.mockSun.setZenithAngle(PercentHelper.getDecimalValue((int)0));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.zenithAngle);
        this.sunLight.getDirection(actualDirection);
        expectedDirection = new Vector3f((float)Math.sqrt(2.0) / 2.0f, 0.0f, (float)(-Math.sqrt(2.0)) / 2.0f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
        this.mockSun.setZenithAngle(PercentHelper.getDecimalValue((int)100));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.zenithAngle);
        this.sunLight.getDirection(actualDirection);
        expectedDirection = new Vector3f((float)Math.sqrt(2.0) / 2.0f, -((float)Math.sqrt(2.0)) / 2.0f, 0.0f);
        expectedDirection.normalize();
        VectorTestHelper.assertVectorEquals(expectedDirection, actualDirection);
    }

    public void testGetWhiteFactor() {
        BasicSun3DTest.assertEquals((Object)PercentHelper.getDecimalValue((int)25), (Object)this.mockSun.getRiseAngle());
        BasicSun3DTest.assertEquals((Object)PercentHelper.getDecimalValue((int)50), (Object)this.mockSun.getZenithAngle());
        BasicSun3DTest.assertEquals((Object)Float.valueOf((float)Math.sqrt(2.0) / 2.0f), (Object)Float.valueOf(this.sun3D.getWhiteFactor().floatValue()));
        this.mockSun.setZenithAngle(PercentHelper.getDecimalValue((int)0));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.zenithAngle);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)0));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        BasicSun3DTest.assertEquals((float)0.0f, (float)this.sun3D.getWhiteFactor().floatValue(), (float)0.001f);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)25));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        BasicSun3DTest.assertEquals((float)0.0f, (float)this.sun3D.getWhiteFactor().floatValue(), (float)0.001f);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)50));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        BasicSun3DTest.assertEquals((float)0.0f, (float)this.sun3D.getWhiteFactor().floatValue(), (float)0.001f);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)75));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        BasicSun3DTest.assertEquals((float)0.0f, (float)this.sun3D.getWhiteFactor().floatValue(), (float)0.001f);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)100));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        BasicSun3DTest.assertEquals((float)0.0f, (float)this.sun3D.getWhiteFactor().floatValue(), (float)0.001f);
        this.mockSun.setZenithAngle(PercentHelper.getDecimalValue((int)50));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.zenithAngle);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)0));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        BasicSun3DTest.assertEquals((float)0.0f, (float)this.sun3D.getWhiteFactor().floatValue(), (float)0.001f);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)25));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        BasicSun3DTest.assertEquals((float)((float)Math.sqrt(2.0) / 2.0f), (float)this.sun3D.getWhiteFactor().floatValue(), (float)0.001f);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)50));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        BasicSun3DTest.assertEquals((float)((float)Math.sqrt(Math.sqrt(2.0) / 2.0)), (float)this.sun3D.getWhiteFactor().floatValue(), (float)0.001f);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)75));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        BasicSun3DTest.assertEquals((float)((float)Math.sqrt(2.0) / 2.0f), (float)this.sun3D.getWhiteFactor().floatValue(), (float)0.001f);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)100));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        BasicSun3DTest.assertEquals((float)0.0f, (float)this.sun3D.getWhiteFactor().floatValue(), (float)0.001f);
        this.mockSun.setZenithAngle(PercentHelper.getDecimalValue((int)100));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.zenithAngle);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)0));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        BasicSun3DTest.assertEquals((float)0.0f, (float)this.sun3D.getWhiteFactor().floatValue(), (float)0.001f);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)25));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        BasicSun3DTest.assertEquals((float)((float)Math.sqrt(Math.sqrt(2.0) / 2.0)), (float)this.sun3D.getWhiteFactor().floatValue(), (float)0.001f);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)50));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        BasicSun3DTest.assertEquals((float)1.0f, (float)this.sun3D.getWhiteFactor().floatValue(), (float)0.001f);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)75));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        BasicSun3DTest.assertEquals((float)((float)Math.sqrt(Math.sqrt(2.0) / 2.0)), (float)this.sun3D.getWhiteFactor().floatValue(), (float)0.001f);
        this.mockSun.setRiseAngle(PercentHelper.getDecimalValue((int)100));
        this.sun3D.update((Publisher)this.mockSun, (Object)SunUpdateCode.riseAngle);
        BasicSun3DTest.assertEquals((float)0.0f, (float)this.sun3D.getWhiteFactor().floatValue(), (float)0.001f);
    }
}

