/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d;

import barsuift.simLife.j3d.AppearanceFactory;
import javax.media.j3d.Appearance;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;
import junit.framework.TestCase;

public class AppearanceFactoryTest
extends TestCase {
    public void testSetColorWithColoringAttributes() {
        Color3f actualColor = new Color3f(0.1f, 0.2f, 0.3f);
        Appearance appearance = new Appearance();
        AppearanceFactory.setColorWithColoringAttributes((Appearance)appearance, (Color3f)actualColor);
        Color3f expectedColor = new Color3f();
        AppearanceFactoryTest.assertFalse((boolean)expectedColor.equals((Tuple3f)actualColor));
        appearance.getColoringAttributes().getColor(expectedColor);
        AppearanceFactoryTest.assertEquals((Object)expectedColor, (Object)actualColor);
    }

    public void testSetColorWithMaterial() {
        Color3f actualAmbientColor = new Color3f(0.1f, 0.2f, 0.3f);
        Color3f actualDiffuseColor = new Color3f(0.2f, 0.4f, 0.6f);
        Color3f actualSpecularColor = new Color3f(0.3f, 0.6f, 0.9f);
        Appearance appearance = new Appearance();
        AppearanceFactory.setColorWithMaterial((Appearance)appearance, (Color3f)actualAmbientColor, (Color3f)actualDiffuseColor, (Color3f)actualSpecularColor);
        Color3f expectedAmbientColor = new Color3f();
        Color3f expectedDiffuseColor = new Color3f();
        Color3f expectedSpecularColor = new Color3f();
        AppearanceFactoryTest.assertFalse((boolean)expectedAmbientColor.equals((Tuple3f)actualAmbientColor));
        AppearanceFactoryTest.assertFalse((boolean)expectedDiffuseColor.equals((Tuple3f)actualDiffuseColor));
        AppearanceFactoryTest.assertFalse((boolean)expectedSpecularColor.equals((Tuple3f)actualSpecularColor));
        appearance.getMaterial().getAmbientColor(expectedAmbientColor);
        appearance.getMaterial().getDiffuseColor(expectedDiffuseColor);
        appearance.getMaterial().getSpecularColor(expectedSpecularColor);
        AppearanceFactoryTest.assertTrue((boolean)expectedAmbientColor.equals((Tuple3f)actualAmbientColor));
        AppearanceFactoryTest.assertTrue((boolean)expectedDiffuseColor.equals((Tuple3f)actualDiffuseColor));
        AppearanceFactoryTest.assertTrue((boolean)expectedSpecularColor.equals((Tuple3f)actualSpecularColor));
    }

    public void testSetCullFace() {
        Appearance appearance = new Appearance();
        AppearanceFactoryTest.assertNull((Object)appearance.getPolygonAttributes());
        AppearanceFactory.setCullFace((Appearance)appearance, (int)0);
        AppearanceFactoryTest.assertEquals((int)0, (int)appearance.getPolygonAttributes().getCullFace());
        AppearanceFactoryTest.assertEquals((boolean)true, (boolean)appearance.getPolygonAttributes().getBackFaceNormalFlip());
        AppearanceFactory.setCullFace((Appearance)appearance, (int)1);
        AppearanceFactoryTest.assertEquals((int)1, (int)appearance.getPolygonAttributes().getCullFace());
        AppearanceFactoryTest.assertEquals((boolean)false, (boolean)appearance.getPolygonAttributes().getBackFaceNormalFlip());
        AppearanceFactory.setCullFace((Appearance)appearance, (int)0);
        AppearanceFactoryTest.assertEquals((boolean)true, (boolean)appearance.getPolygonAttributes().getBackFaceNormalFlip());
        AppearanceFactory.setCullFace((Appearance)appearance, (int)2);
        AppearanceFactoryTest.assertEquals((int)2, (int)appearance.getPolygonAttributes().getCullFace());
        AppearanceFactoryTest.assertEquals((boolean)false, (boolean)appearance.getPolygonAttributes().getBackFaceNormalFlip());
    }
}

