/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.util;

import barsuift.simLife.Randomizer;
import javax.vecmath.Point3d;

public final class PointHelper {
    private PointHelper() {
    }

    public static final Point3d shiftPoint(Point3d point, double distanceMax) {
        double x = point.getX() + Randomizer.random3() * distanceMax;
        double y = point.getY() + Randomizer.random3() * distanceMax;
        double z = point.getZ() + Randomizer.random3() * distanceMax;
        return new Point3d(x, y, z);
    }

    public static final boolean areAlmostEquals(Point3d p1, Point3d p2) {
        return PointHelper.areAlmostEquals(p1, p2, 1.0E-4, 1.0E-4, 1.0E-4);
    }

    public static final boolean areAlmostEquals(Point3d p1, Point3d p2, double xPrecision, double yPrecision, double zPrecision) {
        if (!(Math.abs(p1.getX() - p2.getX()) <= xPrecision)) {
            return false;
        }
        if (!(Math.abs(p1.getY() - p2.getY()) <= yPrecision)) {
            return false;
        }
        return Math.abs(p1.getZ() - p2.getZ()) <= zPrecision;
    }

    public static final boolean isPointWithinBounds(Point3d point, Point3d boundsStartPoint, Point3d boundsEndPoint) {
        if (point.getX() < Math.min(boundsStartPoint.getX(), boundsEndPoint.getX())) {
            return false;
        }
        if (point.getX() > Math.max(boundsStartPoint.getX(), boundsEndPoint.getX())) {
            return false;
        }
        if (point.getY() < Math.min(boundsStartPoint.getY(), boundsEndPoint.getY())) {
            return false;
        }
        if (point.getY() > Math.max(boundsStartPoint.getY(), boundsEndPoint.getY())) {
            return false;
        }
        if (point.getZ() < Math.min(boundsStartPoint.getZ(), boundsEndPoint.getZ())) {
            return false;
        }
        return !(point.getZ() > Math.max(boundsStartPoint.getZ(), boundsEndPoint.getZ()));
    }
}

