/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.util;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public final class BarycentreHelper {
    private BarycentreHelper() {
    }

    public static Point3d getBarycentre(Point3d startPoint, Point3d endPoint, double distance) {
        double maxDistance = startPoint.distance(endPoint);
        double distanceToUse = BarycentreHelper.computeDistanceToUse(maxDistance, distance);
        double ratio = distanceToUse / maxDistance;
        Point3d result = new Point3d();
        result.interpolate((Tuple3d)startPoint, (Tuple3d)endPoint, ratio);
        return result;
    }

    static double computeDistanceToUse(double maxDistance, double distance) {
        if (distance < 0.0) {
            return 0.0;
        }
        if (distance > maxDistance) {
            return maxDistance;
        }
        return distance;
    }
}

