/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.universe.environment;

import barsuift.simLife.environment.Sun;
import barsuift.simLife.environment.SunUpdateCode;
import barsuift.simLife.j3d.universe.environment.Sun3D;
import java.math.BigDecimal;
import java.util.Observable;
import java.util.Observer;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.DirectionalLight;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

public class BasicSun3D
extends Observable
implements Observer,
Sun3D {
    private static BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
    private final Sun sun;
    private float cosinusRiseAngle;
    private float sinusRiseAngle;
    private float cosinusZenithAngle;
    private float sinusZenithAngle;
    private final DirectionalLight light;

    public BasicSun3D(Sun sun) {
        this.sun = sun;
        sun.addObserver((Observer)this);
        this.computeRiseAngleData();
        this.computeZenithAngleData();
        this.light = new DirectionalLight(this.computeColor(), this.computeDirection());
        this.light.setInfluencingBounds((Bounds)bounds);
        this.light.setCapability(15);
        this.light.setCapability(19);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == SunUpdateCode.luminosity) {
            this.light.setColor(this.computeColor());
        }
        if (arg == SunUpdateCode.riseAngle) {
            this.computeRiseAngleData();
            this.light.setDirection(this.computeDirection());
            this.light.setColor(this.computeColor());
        }
        if (arg == SunUpdateCode.zenithAngle) {
            this.computeZenithAngleData();
            this.light.setDirection(this.computeDirection());
            this.light.setColor(this.computeColor());
        }
    }

    private Vector3f computeDirection() {
        Vector3f direction = new Vector3f(this.cosinusRiseAngle, -(this.sinusRiseAngle * this.sinusZenithAngle), -this.cosinusZenithAngle * this.sinusRiseAngle);
        direction.normalize();
        return direction;
    }

    private void computeZenithAngleData() {
        double zenithAngle = this.sun.getZenithAngle().doubleValue() * Math.PI / 2.0;
        this.cosinusZenithAngle = (float)Math.cos(zenithAngle);
        this.sinusZenithAngle = (float)Math.sin(zenithAngle);
    }

    private void computeRiseAngleData() {
        double riseAngle = this.sun.getRiseAngle().doubleValue() * Math.PI;
        this.cosinusRiseAngle = (float)Math.cos(riseAngle);
        this.sinusRiseAngle = (float)Math.sin(riseAngle);
    }

    private Color3f computeColor() {
        float luminosity = this.sun.getLuminosity().floatValue();
        float whiteFactor = this.getWhiteFactor().floatValue();
        Color3f color = new Color3f(luminosity, luminosity * whiteFactor, luminosity * whiteFactor);
        this.setChanged();
        this.notifyObservers(SunUpdateCode.color);
        return color;
    }

    public BigDecimal getWhiteFactor() {
        return new BigDecimal(Math.sqrt(Math.abs(this.sinusRiseAngle * this.sinusZenithAngle)));
    }

    public DirectionalLight getLight() {
        return this.light;
    }
}

