/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.universe;

import barsuift.simLife.j3d.Axis;
import barsuift.simLife.j3d.tree.Tree3D;
import barsuift.simLife.j3d.tree.Tree3DState;
import barsuift.simLife.j3d.tree.TreeLeaf3D;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.j3d.universe.environment.BasicLights;
import barsuift.simLife.j3d.universe.environment.Lights;
import barsuift.simLife.j3d.universe.physic.BasicPhysics;
import barsuift.simLife.j3d.universe.physic.Physics;
import barsuift.simLife.j3d.util.TransformerHelper;
import barsuift.simLife.tree.Tree;
import barsuift.simLife.tree.TreeLeaf;
import barsuift.simLife.universe.Universe;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class BasicUniverse3D
implements Universe3D {
    private BranchGroup root = new BranchGroup();
    private Set<Node> elements3D;
    private Physics physics;
    private Lights lights;

    public BasicUniverse3D() {
        this.root.setCapability(14);
        this.elements3D = new HashSet<Node>();
        this.physics = new BasicPhysics(this);
    }

    public void initFromUniverse(Universe universe) {
        this.lights = new BasicLights(universe.getEnvironment().getSun().getSun3D());
        this.addElement3D((Node)this.lights.getLightsGroup());
        for (Tree tree : universe.getTrees()) {
            this.addTree(tree);
        }
        for (TreeLeaf treeLeaf : universe.getFallenLeaves()) {
            this.addFallenLeaf(treeLeaf.getTreeLeaf3D());
        }
    }

    private void addTree(Tree tree) {
        Tree3D tree3D = tree.getTree3D();
        Point3d treeOriginPoint = ((Tree3DState)tree3D.getState()).getTranslationVector().toPointValue();
        Transform3D translation = TransformerHelper.getTranslationTransform3D(new Vector3d((Tuple3d)treeOriginPoint));
        TransformGroup transformGroup = new TransformGroup(translation);
        BranchGroup treeBranchGroup = new BranchGroup();
        treeBranchGroup.addChild((Node)transformGroup);
        transformGroup.addChild((Node)tree3D.getBranchGroup());
        this.addElement3D((Node)treeBranchGroup);
    }

    private void addFallenLeaf(TreeLeaf3D treeLeaf3D) {
        Point3d treeLeafAttachPoint = treeLeaf3D.getAttachPoint();
        double treeLeafRotation = treeLeaf3D.getRotation();
        Transform3D translation = TransformerHelper.getTranslationTransform3D(new Vector3d((Tuple3d)treeLeafAttachPoint));
        Transform3D rotation = TransformerHelper.getRotationTransform3D(treeLeafRotation, Axis.Y);
        translation.mul(rotation);
        TransformGroup transformGroup = new TransformGroup(translation);
        BranchGroup treeLeafBranchGroup = new BranchGroup();
        treeLeafBranchGroup.addChild((Node)transformGroup);
        transformGroup.addChild(treeLeaf3D.getNode());
        this.addElement3D((Node)treeLeafBranchGroup);
    }

    public void addElement3D(Node element3D) {
        this.elements3D.add(element3D);
        this.root.addChild(element3D);
    }

    public Set<Node> getElements3D() {
        return Collections.unmodifiableSet(this.elements3D);
    }

    public Physics getPhysics() {
        return this.physics;
    }

    public Lights getLights() {
        return this.lights;
    }

    public BranchGroup getUniverseRoot() {
        return this.root;
    }
}

