/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.tree;

import barsuift.simLife.j3d.AppearanceFactory;
import barsuift.simLife.j3d.Axis;
import barsuift.simLife.j3d.Tuple3dState;
import barsuift.simLife.j3d.tree.TreeLeaf3D;
import barsuift.simLife.j3d.tree.TreeLeaf3DState;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.j3d.util.AreaHelper;
import barsuift.simLife.j3d.util.ColorConstants;
import barsuift.simLife.j3d.util.NormalHelper;
import barsuift.simLife.j3d.util.PointHelper;
import barsuift.simLife.j3d.util.ProjectionHelper;
import barsuift.simLife.j3d.util.TransformerHelper;
import barsuift.simLife.tree.LeafUpdateMask;
import barsuift.simLife.tree.TreeLeaf;
import java.math.BigDecimal;
import java.util.Observable;
import java.util.Observer;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class BasicTreeLeaf3D
implements TreeLeaf3D {
    private static final Color3f SPECULAR_COLOR = new Color3f(0.05f, 0.05f, 0.05f);
    private static final Color3f DIFFUSE_COLOR = new Color3f(0.15f, 0.15f, 0.15f);
    private static final int MAX_INCREASE_FACTOR = 10;
    private final TreeLeaf3DState state;
    private Point3d leafAttachPoint;
    private final Point3d initialEndPoint1;
    private final Point3d initialEndPoint2;
    private Point3d endPoint1;
    private Point3d endPoint2;
    private double rotation;
    private TriangleArray leafGeometry;
    private final Shape3D leafShape3D;
    private final Universe3D universe3D;
    private boolean maxSizeReached;
    private final Point3d maxEndPoint1;
    private final Point3d maxEndPoint2;
    private double area;

    public BasicTreeLeaf3D(Universe3D universe3D, TreeLeaf3DState state, TreeLeaf leaf) {
        if (universe3D == null) {
            throw new IllegalArgumentException("Null universe 3D");
        }
        if (leaf == null) {
            throw new IllegalArgumentException("Null tree leaf");
        }
        if (state == null) {
            throw new IllegalArgumentException("Null tree leaf 3D state");
        }
        this.universe3D = universe3D;
        this.state = state;
        this.leafAttachPoint = state.getLeafAttachPoint().toPointValue();
        this.initialEndPoint1 = state.getInitialEndPoint1().toPointValue();
        this.initialEndPoint2 = state.getInitialEndPoint2().toPointValue();
        this.endPoint1 = state.getEndPoint1().toPointValue();
        this.endPoint2 = state.getEndPoint2().toPointValue();
        this.rotation = state.getRotation();
        this.maxEndPoint1 = this.computeMaxEndPoint(this.initialEndPoint1);
        this.maxEndPoint2 = this.computeMaxEndPoint(this.initialEndPoint2);
        leaf.addObserver((Observer)((Object)this));
        this.leafShape3D = new Shape3D();
        this.createLeafGeometry();
        this.setColor(leaf.getEfficiency());
        this.leafShape3D.setCapability(15);
        this.maxSizeReached = false;
    }

    private void setColor(BigDecimal efficiency) {
        Color3f leafColor = new Color3f(ColorConstants.brownYellow);
        leafColor.interpolate((Tuple3f)ColorConstants.green, efficiency.floatValue());
        Appearance appearance = new Appearance();
        AppearanceFactory.setCullFace(appearance, 0);
        AppearanceFactory.setColorWithMaterial(appearance, leafColor, DIFFUSE_COLOR, SPECULAR_COLOR);
        this.leafShape3D.setAppearance(appearance);
    }

    private void createLeafGeometry() {
        this.leafGeometry = new TriangleArray(3, 3);
        this.leafGeometry.setCapability(1);
        this.leafGeometry.setCoordinate(0, new Point3d(0.0, 0.0, 0.0));
        this.resetGeometryPoints();
        this.leafShape3D.setGeometry((Geometry)this.leafGeometry);
        Vector3f polygonNormal = NormalHelper.computeNormal(new Point3d(0.0, 0.0, 0.0), this.endPoint1, this.endPoint2);
        this.leafGeometry.setNormal(0, polygonNormal);
        this.leafGeometry.setNormal(1, polygonNormal);
        this.leafGeometry.setNormal(2, polygonNormal);
    }

    public double getArea() {
        return this.area;
    }

    public boolean isMaxSizeReached() {
        if (this.maxSizeReached) {
            return true;
        }
        if (!PointHelper.areAlmostEquals(this.endPoint1, this.maxEndPoint1)) {
            return false;
        }
        if (!PointHelper.areAlmostEquals(this.endPoint2, this.maxEndPoint2)) {
            return false;
        }
        this.maxSizeReached = true;
        return true;
    }

    private Point3d computeMaxEndPoint(Point3d initialEndPoint) {
        double maxX = 10.0 * initialEndPoint.getX();
        double maxY = 10.0 * initialEndPoint.getY();
        double maxZ = 10.0 * initialEndPoint.getZ();
        return new Point3d(maxX, maxY, maxZ);
    }

    public void increaseSize() {
        if (this.isMaxSizeReached()) {
            return;
        }
        this.endPoint1.x += this.initialEndPoint1.x;
        this.endPoint1.y += this.initialEndPoint1.y;
        this.endPoint1.z += this.initialEndPoint1.z;
        this.endPoint2.x += this.initialEndPoint2.x;
        this.endPoint2.y += this.initialEndPoint2.y;
        this.endPoint2.z += this.initialEndPoint2.z;
        this.resetGeometryPoints();
    }

    public Point3d getAttachPoint() {
        return this.leafAttachPoint;
    }

    public double getRotation() {
        return this.rotation;
    }

    private void resetGeometryPoints() {
        this.leafGeometry.setCoordinates(1, new Point3d[]{this.endPoint1, this.endPoint2});
        this.area = AreaHelper.computeArea(this.leafGeometry);
    }

    public void update(Observable observable, Object arg) {
        if (LeafUpdateMask.isFieldSet((int)((Integer)arg), (int)16)) {
            TreeLeaf leaf = (TreeLeaf)observable;
            this.setColor(leaf.getEfficiency());
        }
        if (LeafUpdateMask.isFieldSet((int)((Integer)arg), (int)2)) {
            this.fall();
        }
    }

    private void fall() {
        Transform3D globalTransform = new Transform3D();
        this.leafShape3D.getLocalToVworld(globalTransform);
        Vector3d translationVector = new Vector3d();
        globalTransform.get(translationVector);
        this.leafAttachPoint = ProjectionHelper.getProjectionPoint(new Point3d((Tuple3d)translationVector));
        this.rotation = TransformerHelper.getRotationFromTransform(globalTransform, Axis.Y);
        this.universe3D.getPhysics().getGravity().fall((BranchGroup)this.leafShape3D.getParent().getParent());
    }

    public TreeLeaf3DState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setLeafAttachPoint(new Tuple3dState((Tuple3d)this.leafAttachPoint));
        this.state.setInitialEndPoint1(new Tuple3dState((Tuple3d)this.initialEndPoint1));
        this.state.setInitialEndPoint2(new Tuple3dState((Tuple3d)this.initialEndPoint2));
        this.state.setEndPoint1(new Tuple3dState((Tuple3d)this.endPoint1));
        this.state.setEndPoint2(new Tuple3dState((Tuple3d)this.endPoint2));
        this.state.setRotation(this.rotation);
    }

    public Node getNode() {
        return this.leafShape3D;
    }
}

