/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.tree;

import barsuift.simLife.j3d.Tuple3dState;
import barsuift.simLife.j3d.tree.TreeBranch3D;
import barsuift.simLife.j3d.tree.TreeBranch3DState;
import barsuift.simLife.j3d.tree.TreeBranchPart3D;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.j3d.util.TransformerHelper;
import barsuift.simLife.tree.TreeBranch;
import barsuift.simLife.tree.TreeBranchPart;
import java.util.ArrayList;
import java.util.List;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class BasicTreeBranch3D
implements TreeBranch3D {
    private final TreeBranch3DState state;
    private final TreeBranch treeBranch;
    private final Vector3d translationVector;
    private final Group group;

    public BasicTreeBranch3D(Universe3D universe3D, TreeBranch3DState state, TreeBranch treeBranch) {
        if (universe3D == null) {
            throw new IllegalArgumentException("Null universe 3D");
        }
        if (state == null) {
            throw new IllegalArgumentException("Null tree branch 3D state");
        }
        if (treeBranch == null) {
            throw new IllegalArgumentException("Null tree branch");
        }
        this.state = state;
        this.translationVector = state.getTranslationVector().toVectorValue();
        this.treeBranch = treeBranch;
        BranchGroup parts = this.createParts();
        this.group = new Group();
        this.group.addChild((Node)parts);
    }

    private BranchGroup createParts() {
        BranchGroup branchGroup = new BranchGroup();
        Point3d currentPartStartPoint = new Point3d(0.0, 0.0, 0.0);
        TransformGroup previousTransformGroup = new TransformGroup();
        branchGroup.addChild((Node)previousTransformGroup);
        for (TreeBranchPart branchPart : this.treeBranch.getParts()) {
            TreeBranchPart3D branchPart3D = branchPart.getBranchPart3D();
            Group branchPartGroup = branchPart3D.getGroup();
            BranchGroup currentBranchGroup = new BranchGroup();
            Vector3d translationVector = new Vector3d((Tuple3d)currentPartStartPoint);
            TransformGroup currentTransformGroup = TransformerHelper.getTranslationTransformGroup(translationVector);
            currentBranchGroup.addChild((Node)currentTransformGroup);
            currentTransformGroup.addChild((Node)branchPartGroup);
            previousTransformGroup.addChild((Node)currentBranchGroup);
            currentPartStartPoint = branchPart3D.getEndPoint();
            previousTransformGroup = currentTransformGroup;
        }
        return branchGroup;
    }

    public Point3d getEndPoint() {
        List parts = this.treeBranch.getParts();
        return ((TreeBranchPart)parts.get(parts.size() - 1)).getBranchPart3D().getEndPoint();
    }

    public Vector3d getTranslationVector() {
        return this.translationVector;
    }

    public TreeBranch3DState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setTranslationVector(new Tuple3dState((Tuple3d)this.translationVector));
    }

    public Group getGroup() {
        return this.group;
    }

    public List<TreeBranchPart3D> getBranchParts() {
        ArrayList<TreeBranchPart3D> result = new ArrayList<TreeBranchPart3D>();
        List parts = this.treeBranch.getParts();
        for (TreeBranchPart treeBranchPart : parts) {
            result.add(treeBranchPart.getBranchPart3D());
        }
        return result;
    }
}

