/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.universe;

import barsuift.simLife.CoreDataCreatorForTests;
import barsuift.simLife.j3d.tree.BasicTreeLeaf3D;
import barsuift.simLife.j3d.tree.TreeLeaf3DState;
import barsuift.simLife.j3d.tree.TreeLeaf3DStateFactory;
import barsuift.simLife.j3d.universe.BasicUniverse3D;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.tree.MockTree;
import barsuift.simLife.tree.MockTreeLeaf;
import barsuift.simLife.tree.Tree;
import barsuift.simLife.tree.TreeLeaf;
import barsuift.simLife.universe.MockUniverse;
import barsuift.simLife.universe.Universe;
import java.util.Set;
import javax.media.j3d.BranchGroup;
import javax.vecmath.Point3d;
import junit.framework.TestCase;

public class BasicUniverse3DTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBasicUniverse3D() {
        BasicUniverse3D universe3D = new BasicUniverse3D();
        BasicUniverse3DTest.assertNotNull((Object)universe3D.getElements3D());
        BasicUniverse3DTest.assertNotNull((Object)universe3D.getPhysics());
        BranchGroup root = universe3D.getUniverseRoot();
        BasicUniverse3DTest.assertNotNull((Object)root);
        BasicUniverse3DTest.assertEquals((int)0, (int)root.numChildren());
        BasicUniverse3DTest.assertTrue((boolean)root.getCapability(14));
    }

    public void testInitFromUniverse() {
        BasicUniverse3D universe3D = new BasicUniverse3D();
        MockUniverse universe = new MockUniverse();
        MockTreeLeaf treeLeaf = new MockTreeLeaf();
        treeLeaf.setState(CoreDataCreatorForTests.createSpecificTreeLeafState());
        universe.addFallenLeaf((TreeLeaf)treeLeaf);
        MockTree tree = new MockTree();
        tree.setState(CoreDataCreatorForTests.createSpecificTreeState());
        universe.addTree((Tree)tree);
        universe3D.initFromUniverse((Universe)universe);
        BasicUniverse3DTest.assertNotNull((Object)universe3D.getLights());
        Set elements3d = universe3D.getElements3D();
        BasicUniverse3DTest.assertNotNull((Object)elements3d);
        BasicUniverse3DTest.assertEquals((int)3, (int)elements3d.size());
        BasicUniverse3DTest.assertTrue((boolean)elements3d.contains(tree.getTree3D().getBranchGroup().getParent().getParent()));
        BasicUniverse3DTest.assertTrue((boolean)elements3d.contains(treeLeaf.getTreeLeaf3D().getNode().getParent().getParent()));
    }

    public void testAddElement3D() {
        BasicUniverse3D universe3D = new BasicUniverse3D();
        TreeLeaf3DStateFactory stateFactory = new TreeLeaf3DStateFactory();
        Point3d leafAttachPoint = new Point3d(Math.random(), Math.random(), Math.random());
        TreeLeaf3DState leaf3dState = stateFactory.createRandomTreeLeaf3DState(leafAttachPoint);
        BasicTreeLeaf3D treeLeaf3D = new BasicTreeLeaf3D((Universe3D)universe3D, leaf3dState, (TreeLeaf)new MockTreeLeaf());
        universe3D.addElement3D(treeLeaf3D.getNode());
        Set elements3d = universe3D.getElements3D();
        BasicUniverse3DTest.assertNotNull((Object)elements3d);
        BasicUniverse3DTest.assertEquals((int)1, (int)elements3d.size());
        BasicUniverse3DTest.assertTrue((boolean)elements3d.contains(treeLeaf3D.getNode()));
        BranchGroup root = universe3D.getUniverseRoot();
        BasicUniverse3DTest.assertNotNull((Object)root);
        BasicUniverse3DTest.assertEquals((int)1, (int)root.numChildren());
        BasicUniverse3DTest.assertEquals((Object)treeLeaf3D.getNode(), (Object)root.getChild(0));
    }
}

