/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.tree;

import barsuift.simLife.j3d.DisplayDataCreatorForTests;
import barsuift.simLife.j3d.Tuple3dState;
import barsuift.simLife.j3d.helper.CompilerHelper;
import barsuift.simLife.j3d.helper.Structure3DHelper;
import barsuift.simLife.j3d.helper.VectorTestHelper;
import barsuift.simLife.j3d.tree.BasicTree3D;
import barsuift.simLife.j3d.tree.MockTreeBranch3D;
import barsuift.simLife.j3d.tree.Tree3DState;
import barsuift.simLife.j3d.universe.MockUniverse3D;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.tree.MockTree;
import barsuift.simLife.tree.MockTreeBranch;
import barsuift.simLife.tree.Tree;
import barsuift.simLife.tree.TreeBranch;
import java.util.Enumeration;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;
import junit.framework.TestCase;

public class BasicTree3DTest
extends TestCase {
    private int nbBranches;
    private MockUniverse3D mockUniverse3D;
    private MockTree mockTree;
    private Tree3DState tree3DState;

    protected void setUp() throws Exception {
        super.setUp();
        this.mockTree = new MockTree();
        this.nbBranches = 5;
        for (int index = 0; index < this.nbBranches; ++index) {
            MockTreeBranch mockBranch = new MockTreeBranch();
            Tuple3dState translationVector = DisplayDataCreatorForTests.createRandomTupleState();
            MockTreeBranch3D mockBranch3D = (MockTreeBranch3D)mockBranch.getBranch3D();
            mockBranch3D.getState().setTranslationVector(translationVector);
            this.mockTree.addBranch((TreeBranch)mockBranch);
        }
        this.mockUniverse3D = new MockUniverse3D();
        this.tree3DState = DisplayDataCreatorForTests.createRandomTree3DState();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.nbBranches = 0;
        this.mockUniverse3D = null;
        this.mockTree = null;
        this.tree3DState = null;
    }

    public void testConstructor() {
        try {
            new BasicTree3D((Universe3D)this.mockUniverse3D, null, (Tree)this.mockTree);
            BasicTree3DTest.fail((String)"Should throw new IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTree3D((Universe3D)this.mockUniverse3D, this.tree3DState, null);
            BasicTree3DTest.fail((String)"Should throw new IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTree3D(null, this.tree3DState, (Tree)this.mockTree);
            BasicTree3DTest.fail((String)"Should throw new IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetState() {
        BasicTree3D tree3D = new BasicTree3D((Universe3D)this.mockUniverse3D, this.tree3DState, (Tree)this.mockTree);
        BasicTree3DTest.assertEquals((Object)this.tree3DState, (Object)tree3D.getState());
        BasicTree3DTest.assertSame((Object)this.tree3DState, (Object)tree3D.getState());
    }

    public void testTree3D() {
        BasicTree3D tree3D = new BasicTree3D((Universe3D)this.mockUniverse3D, this.tree3DState, (Tree)this.mockTree);
        BranchGroup branchGroup = tree3D.getBranchGroup();
        CompilerHelper.compile((Group)branchGroup);
        BasicTree3DTest.assertEquals((int)this.nbBranches, (int)tree3D.getBranches().size());
        int nbTimesTrunkGroupIsFound = 0;
        int nbBranchesFound = 0;
        Enumeration enumeration = branchGroup.getAllChildren();
        while (enumeration.hasMoreElements()) {
            Object child = enumeration.nextElement();
            if (child instanceof BranchGroup) {
                BranchGroup branchBranchGroup = (BranchGroup)child;
                Structure3DHelper.assertExactlyOneTransformGroup(branchBranchGroup);
                TransformGroup transformGroup = (TransformGroup)branchBranchGroup.getChild(0);
                Transform3D transform3D = new Transform3D();
                transformGroup.getTransform(transform3D);
                Vector3d translationVector = new Vector3d();
                transform3D.get(translationVector);
                TreeBranch treeBranch = (TreeBranch)this.mockTree.getBranches().get(nbBranchesFound);
                Vector3d expectedTranslationVector = treeBranch.getBranch3D().getTranslationVector();
                VectorTestHelper.assertVectorEquals(expectedTranslationVector, translationVector);
                Structure3DHelper.assertExactlyOneGroup(transformGroup);
                Group specificGroupForTheBranch = (Group)transformGroup.getChild(0);
                BasicTree3DTest.assertNotNull((Object)specificGroupForTheBranch);
                ++nbBranchesFound;
                continue;
            }
            if (child instanceof Group) {
                BasicTree3DTest.assertEquals((String)"We should have only one trunk", (int)1, (int)(++nbTimesTrunkGroupIsFound));
                continue;
            }
            BasicTree3DTest.fail((String)("There should be no other children. child is instance of " + child.getClass()));
        }
        BasicTree3DTest.assertEquals((int)this.nbBranches, (int)nbBranchesFound);
    }
}

