/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.helper;

import javax.vecmath.Point3d;
import junit.framework.Assert;

public final class PointTestHelper
extends Assert {
    private PointTestHelper() {
    }

    public static final void assertPointEquals(Point3d p1, Point3d p2) {
        PointTestHelper.assertPointEquals(p1, p2, 1.0E-4, 1.0E-4, 1.0E-4);
    }

    public static final void assertPointEquals(Point3d p1, Point3d p2, double xPrecision, double yPrecision, double zPrecision) {
        PointTestHelper.assertEquals((double)p1.getX(), (double)p2.getX(), (double)xPrecision);
        PointTestHelper.assertEquals((double)p1.getY(), (double)p2.getY(), (double)yPrecision);
        PointTestHelper.assertEquals((double)p1.getZ(), (double)p2.getZ(), (double)zPrecision);
    }

    public static final void assertPointIsWithinBounds(Point3d point, Point3d boundsStartPoint, Point3d boundsEndPoint) {
        double boundsMinX = Math.min(boundsStartPoint.getX(), boundsEndPoint.getX());
        double boundsMaxX = Math.max(boundsStartPoint.getX(), boundsEndPoint.getX());
        double boundsMinY = Math.min(boundsStartPoint.getY(), boundsEndPoint.getY());
        double boundsMaxY = Math.max(boundsStartPoint.getY(), boundsEndPoint.getY());
        double boundsMinZ = Math.min(boundsStartPoint.getZ(), boundsEndPoint.getZ());
        double boundsMaxZ = Math.max(boundsStartPoint.getZ(), boundsEndPoint.getZ());
        PointTestHelper.assertTrue((String)("\"x >= min\" : " + point.getX() + " >= " + boundsMinX), (point.getX() >= boundsMinX ? 1 : 0) != 0);
        PointTestHelper.assertTrue((String)("\"x <= max\" : " + point.getX() + " <= " + boundsMaxX), (point.getX() <= boundsMaxX ? 1 : 0) != 0);
        PointTestHelper.assertTrue((String)("\"y >= min\" : " + point.getY() + " >= " + boundsMinY), (point.getY() >= boundsMinY ? 1 : 0) != 0);
        PointTestHelper.assertTrue((String)("\"y <= max\" : " + point.getY() + " <= " + boundsMaxY), (point.getY() <= boundsMaxY ? 1 : 0) != 0);
        PointTestHelper.assertTrue((String)("\"z >= min\" : " + point.getZ() + " >= " + boundsMinZ), (point.getZ() >= boundsMinZ ? 1 : 0) != 0);
        PointTestHelper.assertTrue((String)("\"z <= max\" : " + point.getZ() + " <= " + boundsMaxZ), (point.getZ() <= boundsMaxZ ? 1 : 0) != 0);
    }
}

