/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.universe.physic;

import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.j3d.universe.physic.Gravity;
import barsuift.simLife.j3d.util.ProjectionHelper;
import javax.media.j3d.Alpha;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Interpolator;
import javax.media.j3d.Node;
import javax.media.j3d.RotPosPathInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class BasicGravity
implements Gravity {
    private Universe3D universe3D;

    public BasicGravity(Universe3D universe3D) {
        this.universe3D = universe3D;
    }

    public void fall(BranchGroup groupToFall) {
        TransformGroup tg = (TransformGroup)groupToFall.getChild(0);
        Node node = tg.getChild(0);
        Transform3D transform3D = this.getGlobalTransform3D(node);
        groupToFall.detach();
        tg.setTransform(transform3D);
        Interpolator gravity = this.createGravityInterpolator(tg);
        this.addToUniverse(groupToFall, gravity);
    }

    private void addToUniverse(BranchGroup groupToFall, Interpolator gravity) {
        BranchGroup bg = new BranchGroup();
        bg.addChild((Node)groupToFall);
        bg.addChild((Node)gravity);
        this.universe3D.addElement3D((Node)bg);
    }

    private Transform3D getGlobalTransform3D(Node node) {
        Transform3D transform = new Transform3D();
        node.getLocalToVworld(transform);
        return transform;
    }

    private Interpolator createGravityInterpolator(TransformGroup newTransformGroup) {
        Vector3f translationVector = new Vector3f();
        Transform3D transform = new Transform3D();
        newTransformGroup.getTransform(transform);
        transform.get(translationVector);
        Quat4f rotationQuat = new Quat4f();
        transform.get(rotationQuat);
        float[] knots = new float[]{0.0f, 1.0f};
        Point3f position1 = new Point3f(translationVector.getX(), translationVector.getY(), translationVector.getZ());
        Point3f position2 = ProjectionHelper.getProjectionPoint(position1);
        Point3f[] positions = new Point3f[]{position1, position2};
        Quat4f[] rotations = new Quat4f[]{rotationQuat, rotationQuat};
        Alpha alpha = new Alpha(1, (long)(translationVector.getY() * 1000.0f));
        alpha.setStartTime(System.currentTimeMillis());
        RotPosPathInterpolator gravity = new RotPosPathInterpolator(alpha, newTransformGroup, new Transform3D(), knots, rotations, positions);
        gravity.setSchedulingBounds((Bounds)new BoundingSphere());
        return gravity;
    }

    public String toString() {
        return "BasicGravity []";
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }
}

