/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.tree;

import barsuift.simLife.j3d.helper.ColorTestHelper;
import barsuift.simLife.j3d.tree.BasicTreeTrunk3D;
import barsuift.simLife.j3d.tree.TreeTrunk3DState;
import barsuift.simLife.j3d.tree.TreeTrunk3DStateFactory;
import barsuift.simLife.j3d.tree.helper.BasicTreeTrunk3DTestHelper;
import barsuift.simLife.j3d.universe.MockUniverse3D;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.j3d.util.ColorConstants;
import barsuift.simLife.tree.MockTreeTrunk;
import barsuift.simLife.tree.TreeTrunk;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import junit.framework.TestCase;

public class BasicTreeTrunk3DTest
extends TestCase {
    private TreeTrunk3DState trunk3DState;
    private MockTreeTrunk mockTrunk;
    private MockUniverse3D mockUniverse3D;

    protected void setUp() throws Exception {
        super.setUp();
        TreeTrunk3DStateFactory stateFactory = new TreeTrunk3DStateFactory();
        this.trunk3DState = stateFactory.createRandomTreeTrunk3DState();
        this.mockTrunk = new MockTreeTrunk();
        this.mockUniverse3D = new MockUniverse3D();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.trunk3DState = null;
        this.mockTrunk = null;
        this.mockUniverse3D = null;
    }

    public void testConstructor() {
        try {
            new BasicTreeTrunk3D((Universe3D)this.mockUniverse3D, null, (TreeTrunk)this.mockTrunk);
            BasicTreeTrunk3DTest.fail((String)"Should throw new IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTreeTrunk3D((Universe3D)this.mockUniverse3D, this.trunk3DState, null);
            BasicTreeTrunk3DTest.fail((String)"Should throw new IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTreeTrunk3D(null, this.trunk3DState, (TreeTrunk)this.mockTrunk);
            BasicTreeTrunk3DTest.fail((String)"Should throw new IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetState() {
        BasicTreeTrunk3D trunk3D = new BasicTreeTrunk3D((Universe3D)this.mockUniverse3D, this.trunk3DState, (TreeTrunk)this.mockTrunk);
        BasicTreeTrunk3DTest.assertEquals((Object)this.trunk3DState, (Object)trunk3D.getState());
    }

    public void testCreateTrunk() {
        float radius = 0.5f;
        float height = 4.0f;
        this.mockTrunk.setHeight(height);
        this.mockTrunk.setRadius(radius);
        BasicTreeTrunk3D trunk3D = new BasicTreeTrunk3D((Universe3D)this.mockUniverse3D, this.trunk3DState, (TreeTrunk)this.mockTrunk);
        Point3d expectedLowerBottom = new Point3d(-0.5, -2.0, -0.5);
        Point3d expectedUpperBottom = new Point3d(0.5, -2.0, 0.5);
        Point3d expectedMovedLowerBottom = new Point3d(-0.5, 0.0, -0.5);
        Point3d expectedMovedUpperBottom = new Point3d(0.5, 0.0, 0.5);
        Point3d expectedLowerTop = new Point3d(-0.5, 2.0, -0.5);
        Point3d expectedUpperTop = new Point3d(0.5, 2.0, 0.5);
        Point3d expectedMovedLowerTop = new Point3d(-0.5, 4.0, -0.5);
        Point3d expectedMovedUpperTop = new Point3d(0.5, 4.0, 0.5);
        BasicTreeTrunk3DTestHelper.checkTrunk3D(trunk3D, height, radius, expectedLowerBottom, expectedUpperBottom, expectedMovedLowerBottom, expectedMovedUpperBottom, expectedLowerTop, expectedUpperTop, expectedMovedLowerTop, expectedMovedUpperTop);
        ColorTestHelper.testColorFromMaterial(trunk3D.getTrunk().getAppearance(), ColorConstants.brown, new Color3f(0.05f, 0.05f, 0.05f), new Color3f(0.15f, 0.15f, 0.15f));
    }
}

