/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.tree;

import barsuift.simLife.Percent;
import barsuift.simLife.j3d.AppearanceFactory;
import barsuift.simLife.j3d.Axis;
import barsuift.simLife.j3d.Point3dState;
import barsuift.simLife.j3d.tree.TreeLeaf3D;
import barsuift.simLife.j3d.tree.TreeLeaf3DState;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.j3d.util.AreaHelper;
import barsuift.simLife.j3d.util.ColorConstants;
import barsuift.simLife.j3d.util.NormalHelper;
import barsuift.simLife.j3d.util.PointHelper;
import barsuift.simLife.j3d.util.ProjectionHelper;
import barsuift.simLife.j3d.util.TransformerHelper;
import barsuift.simLife.tree.LeafUpdateCode;
import barsuift.simLife.tree.TreeLeaf;
import java.util.Observable;
import java.util.Observer;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class BasicTreeLeaf3D
implements TreeLeaf3D {
    private static final int MAX_INCREASE_FACTOR = 10;
    private TriangleArray leafGeometry;
    private Shape3D leafShape3D;
    private TreeLeaf3DState state;
    private Universe3D universe3D;
    private final BranchGroup branchGroup;

    public BasicTreeLeaf3D(Universe3D universe3D, TreeLeaf3DState state, TreeLeaf leaf) {
        if (universe3D == null) {
            throw new IllegalArgumentException("Null universe 3D");
        }
        if (leaf == null) {
            throw new IllegalArgumentException("Null tree leaf");
        }
        if (state == null) {
            throw new IllegalArgumentException("Null tree leaf 3D state");
        }
        this.universe3D = universe3D;
        this.state = new TreeLeaf3DState(state);
        leaf.addObserver((Observer)((Object)this));
        this.leafShape3D = new Shape3D();
        this.branchGroup = new BranchGroup();
        this.branchGroup.addChild((Node)this.leafShape3D);
        this.createLeafGeometry();
        this.setColor(leaf.getEfficiency());
        this.leafShape3D.setCapability(15);
        this.branchGroup.setCapability(17);
    }

    private void setColor(Percent efficiency) {
        Color3f leafColor = new Color3f(ColorConstants.brownYellow);
        leafColor.interpolate((Tuple3f)ColorConstants.green, efficiency.getValue().floatValue());
        Appearance appearance = new Appearance();
        AppearanceFactory.setCullFace(appearance, 0);
        AppearanceFactory.setColorWithMaterial(appearance, leafColor, new Color3f(0.15f, 0.15f, 0.15f), new Color3f(0.05f, 0.05f, 0.05f));
        this.leafShape3D.setAppearance(appearance);
    }

    private void createLeafGeometry() {
        this.leafGeometry = new TriangleArray(3, 3);
        this.leafGeometry.setCapability(1);
        this.resetGeometryPoints();
        this.leafShape3D.setGeometry((Geometry)this.leafGeometry);
        Vector3f polygonNormal = NormalHelper.computeNormal(new Point3d(0.0, 0.0, 0.0), this.state.getEndPoint1().toPointValue(), this.state.getEndPoint2().toPointValue());
        this.leafGeometry.setNormal(0, polygonNormal);
        this.leafGeometry.setNormal(1, polygonNormal);
        this.leafGeometry.setNormal(2, polygonNormal);
    }

    public double getArea() {
        return AreaHelper.computeArea(this.leafGeometry);
    }

    public boolean isMaxSizeReached() {
        Point3dState initialEndPoint1 = this.state.getInitialEndPoint1();
        double maxX1 = 10.0 * initialEndPoint1.getX();
        double maxY1 = 10.0 * initialEndPoint1.getY();
        double maxZ1 = 10.0 * initialEndPoint1.getZ();
        Point3d actualEndPoint1 = this.state.getEndPoint1().toPointValue();
        boolean areAlmostEquals1 = PointHelper.areAlmostEquals(actualEndPoint1, new Point3d(maxX1, maxY1, maxZ1));
        if (!areAlmostEquals1) {
            return false;
        }
        Point3dState initialEndPoint2 = this.state.getInitialEndPoint2();
        double maxX2 = 10.0 * initialEndPoint2.getX();
        double maxY2 = 10.0 * initialEndPoint2.getY();
        double maxZ2 = 10.0 * initialEndPoint2.getZ();
        Point3d actualEndPoint2 = this.state.getEndPoint2().toPointValue();
        boolean areAlmostEquals2 = PointHelper.areAlmostEquals(actualEndPoint2, new Point3d(maxX2, maxY2, maxZ2));
        return areAlmostEquals2;
    }

    public void increaseSize() {
        if (this.isMaxSizeReached()) {
            return;
        }
        this.state.getEndPoint1().setX(this.state.getEndPoint1().getX() + this.state.getInitialEndPoint1().getX());
        this.state.getEndPoint1().setY(this.state.getEndPoint1().getY() + this.state.getInitialEndPoint1().getY());
        this.state.getEndPoint1().setZ(this.state.getEndPoint1().getZ() + this.state.getInitialEndPoint1().getZ());
        this.state.getEndPoint2().setX(this.state.getEndPoint2().getX() + this.state.getInitialEndPoint2().getX());
        this.state.getEndPoint2().setY(this.state.getEndPoint2().getY() + this.state.getInitialEndPoint2().getY());
        this.state.getEndPoint2().setZ(this.state.getEndPoint2().getZ() + this.state.getInitialEndPoint2().getZ());
        this.resetGeometryPoints();
    }

    public Point3d getAttachPoint() {
        return this.state.getLeafAttachPoint().toPointValue();
    }

    private void resetGeometryPoints() {
        this.leafGeometry.setCoordinate(0, new Point3d(0.0, 0.0, 0.0));
        this.leafGeometry.setCoordinate(1, this.state.getEndPoint1().toPointValue());
        this.leafGeometry.setCoordinate(2, this.state.getEndPoint2().toPointValue());
    }

    public void update(Observable observable, Object arg) {
        if (arg == LeafUpdateCode.efficiency) {
            TreeLeaf leaf = (TreeLeaf)observable;
            this.setColor(leaf.getEfficiency());
        }
        if (arg == LeafUpdateCode.fall) {
            this.fall();
        }
    }

    private void fall() {
        Transform3D globalTransform = new Transform3D();
        this.branchGroup.getLocalToVworld(globalTransform);
        Vector3d translationVector = new Vector3d();
        globalTransform.get(translationVector);
        Point3d projectionPoint = ProjectionHelper.getProjectionPoint(new Point3d((Tuple3d)translationVector));
        this.state.setLeafAttachPoint(new Point3dState(projectionPoint));
        double angle = TransformerHelper.getRotationFromTransform(globalTransform, Axis.Y);
        this.state.setRotation(angle);
        this.universe3D.getPhysics().getGravity().fall((BranchGroup)this.branchGroup.getParent().getParent());
    }

    public TreeLeaf3DState getState() {
        return new TreeLeaf3DState(this.state);
    }

    public BranchGroup getBranchGroup() {
        return this.branchGroup;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicTreeLeaf3D other = (BasicTreeLeaf3D)obj;
        return !(this.state == null ? other.state != null : !this.state.equals((Object)other.state));
    }

    public String toString() {
        return "BasicTreeLeaf3D [state=" + this.state + "]";
    }
}

