/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.tree.helper;

import barsuift.simLife.j3d.helper.PointTestHelper;
import barsuift.simLife.j3d.tree.BasicTreeTrunk3D;
import com.sun.j3d.utils.geometry.Cylinder;
import java.util.Enumeration;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import junit.framework.Assert;

public final class BasicTreeTrunk3DTestHelper
extends Assert {
    private BasicTreeTrunk3DTestHelper() {
    }

    public static void checkTrunk3D(BasicTreeTrunk3D trunk3D, float expectedHeight, float expectedRadius, Point3d expectedLowerBottom, Point3d expectedUpperBottom, Point3d expectedMovedLowerBottom, Point3d expectedMovedUpperBottom, Point3d expectedLowerTop, Point3d expectedUpperTop, Point3d expectedMovedLowerTop, Point3d expectedMovedUpperTop) {
        Cylinder trunkCylinder = trunk3D.getTrunk();
        BasicTreeTrunk3DTestHelper.assertEquals((Object)Float.valueOf(expectedHeight), (Object)Float.valueOf(trunkCylinder.getHeight()));
        BasicTreeTrunk3DTestHelper.assertEquals((Object)Float.valueOf(expectedRadius), (Object)Float.valueOf(trunkCylinder.getRadius()));
        TransformGroup trunkTransformGroup = (TransformGroup)trunk3D.getGroup().getChild(0);
        Enumeration transformChilds = trunkTransformGroup.getAllChildren();
        BasicTreeTrunk3DTestHelper.assertTrue((boolean)transformChilds.hasMoreElements());
        SceneGraphObject child = (SceneGraphObject)transformChilds.nextElement();
        BasicTreeTrunk3DTestHelper.assertEquals((Object)trunkCylinder, (Object)child);
        BasicTreeTrunk3DTestHelper.assertFalse((boolean)transformChilds.hasMoreElements());
        Transform3D transform3D = new Transform3D();
        trunkTransformGroup.getTransform(transform3D);
        Shape3D bottom = trunkCylinder.getShape(2);
        BoundingBox bottomBounds = (BoundingBox)bottom.getBounds();
        Point3d lowerBottom = new Point3d();
        bottomBounds.getLower(lowerBottom);
        Point3d movedLowerBottom = new Point3d();
        transform3D.transform(lowerBottom, movedLowerBottom);
        Point3d upperBottom = new Point3d();
        bottomBounds.getUpper(upperBottom);
        Point3d movedUpperBottom = new Point3d();
        transform3D.transform(upperBottom, movedUpperBottom);
        PointTestHelper.assertPointEquals(expectedLowerBottom, lowerBottom, 0.02, 1.0E-4, 0.02);
        PointTestHelper.assertPointEquals(expectedMovedLowerBottom, movedLowerBottom, 0.02, 1.0E-4, 0.02);
        PointTestHelper.assertPointEquals(expectedUpperBottom, upperBottom, 0.02, 1.0E-4, 0.02);
        PointTestHelper.assertPointEquals(expectedMovedUpperBottom, movedUpperBottom, 0.02, 1.0E-4, 0.02);
        Shape3D top = trunkCylinder.getShape(1);
        BoundingBox topBounds = (BoundingBox)top.getBounds();
        Point3d lowerTop = new Point3d();
        topBounds.getLower(lowerTop);
        Point3d movedLowerTop = new Point3d();
        transform3D.transform(lowerTop, movedLowerTop);
        Point3d upperTop = new Point3d();
        topBounds.getUpper(upperTop);
        Point3d movedUpperTop = new Point3d();
        transform3D.transform(upperTop, movedUpperTop);
        PointTestHelper.assertPointEquals(expectedLowerTop, lowerTop, 0.02, 1.0E-4, 0.02);
        PointTestHelper.assertPointEquals(expectedMovedLowerTop, movedLowerTop, 0.02, 1.0E-4, 0.02);
        PointTestHelper.assertPointEquals(expectedUpperTop, upperTop, 0.02, 1.0E-4, 0.02);
        PointTestHelper.assertPointEquals(expectedMovedUpperTop, movedUpperTop, 0.02, 1.0E-4, 0.02);
    }
}

