/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.tree.helper;

import barsuift.simLife.j3d.helper.PointTestHelper;
import barsuift.simLife.j3d.util.ColorConstants;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import junit.framework.Assert;

public final class BasicTreeBranchPart3DTestHelper
extends Assert {
    private BasicTreeBranchPart3DTestHelper() {
    }

    public static void testGeometry(Geometry branchGeometry, Point3d expectedStartPoint, Point3d expectedEndPoint) {
        BasicTreeBranchPart3DTestHelper.assertTrue((boolean)(branchGeometry instanceof LineArray));
        LineArray branchLine = (LineArray)branchGeometry;
        Point3d actualStartPoint = new Point3d();
        Point3d actualEndPoint = new Point3d();
        branchLine.getCoordinate(0, actualStartPoint);
        branchLine.getCoordinate(1, actualEndPoint);
        PointTestHelper.assertPointEquals(expectedStartPoint, actualStartPoint);
        PointTestHelper.assertPointEquals(expectedEndPoint, actualEndPoint);
        BasicTreeBranchPart3DTestHelper.assertEquals((String)"Ony 2 vertices for a branch line", (int)2, (int)branchLine.getVertexCount());
    }

    public static void testAppearance(Appearance branchAppearance) {
        Color3f actualColor = new Color3f();
        branchAppearance.getColoringAttributes().getColor(actualColor);
        Color3f expectedColor = ColorConstants.brown;
        BasicTreeBranchPart3DTestHelper.assertEquals((Object)expectedColor, (Object)actualColor);
    }
}

