/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.tree;

import barsuift.simLife.j3d.DisplayDataCreatorForTests;
import barsuift.simLife.j3d.Point3dState;
import barsuift.simLife.j3d.helper.CompilerHelper;
import barsuift.simLife.j3d.helper.Structure3DHelper;
import barsuift.simLife.j3d.helper.VectorTestHelper;
import barsuift.simLife.j3d.tree.BasicTreeBranch3D;
import barsuift.simLife.j3d.tree.MockTreeBranchPart3D;
import barsuift.simLife.j3d.tree.TreeBranch3DState;
import barsuift.simLife.j3d.universe.MockUniverse3D;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.tree.MockTreeBranch;
import barsuift.simLife.tree.MockTreeBranchPart;
import barsuift.simLife.tree.TreeBranch;
import barsuift.simLife.tree.TreeBranchPart;
import java.util.ArrayList;
import java.util.List;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import junit.framework.TestCase;

public class BasicTreeBranch3DTest
extends TestCase {
    private int nbParts;
    private MockUniverse3D mockUniverse3D;
    private MockTreeBranch mockBranch;
    private TreeBranch3DState branch3DState;
    private List<Point3dState> previousPartEndPoints;

    protected void setUp() throws Exception {
        super.setUp();
        this.mockBranch = new MockTreeBranch();
        this.nbParts = 5;
        this.previousPartEndPoints = new ArrayList<Point3dState>();
        Point3dState partEndPoint = new Point3dState();
        for (int index = 0; index < this.nbParts; ++index) {
            this.previousPartEndPoints.add(partEndPoint);
            MockTreeBranchPart mockBranchPart = new MockTreeBranchPart();
            partEndPoint = DisplayDataCreatorForTests.createRandomPointState();
            MockTreeBranchPart3D mockBranchPart3D = (MockTreeBranchPart3D)mockBranchPart.getBranchPart3D();
            mockBranchPart3D.getState().setEndPoint(partEndPoint);
            mockBranchPart3D.setEndPoint(partEndPoint.toPointValue());
            this.mockBranch.addPart((TreeBranchPart)mockBranchPart);
        }
        this.mockUniverse3D = new MockUniverse3D();
        this.branch3DState = DisplayDataCreatorForTests.createRandomTreeBranch3DState();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.nbParts = 0;
        this.mockUniverse3D = null;
        this.mockBranch = null;
        this.branch3DState = null;
        this.previousPartEndPoints = null;
    }

    public void testConstructor() {
        try {
            new BasicTreeBranch3D((Universe3D)this.mockUniverse3D, null, (TreeBranch)this.mockBranch);
            BasicTreeBranch3DTest.fail((String)"Should throw new IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTreeBranch3D((Universe3D)this.mockUniverse3D, this.branch3DState, null);
            BasicTreeBranch3DTest.fail((String)"Should throw new IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTreeBranch3D(null, this.branch3DState, (TreeBranch)this.mockBranch);
            BasicTreeBranch3DTest.fail((String)"Should throw new IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetState() {
        BasicTreeBranch3D branch3D = new BasicTreeBranch3D((Universe3D)this.mockUniverse3D, this.branch3DState, (TreeBranch)this.mockBranch);
        BasicTreeBranch3DTest.assertEquals((Object)this.branch3DState, (Object)branch3D.getState());
    }

    public void testTreeBranch3D() {
        BasicTreeBranch3D branch3D = new BasicTreeBranch3D((Universe3D)this.mockUniverse3D, this.branch3DState, (TreeBranch)this.mockBranch);
        CompilerHelper.compile(branch3D.getGroup());
        BasicTreeBranch3DTest.assertEquals((int)this.nbParts, (int)branch3D.getBranchParts().size());
        List parts = this.mockBranch.getParts();
        BasicTreeBranch3DTest.assertEquals((Object)((TreeBranchPart)parts.get(parts.size() - 1)).getBranchPart3D().getEndPoint(), (Object)branch3D.getEndPoint());
        Node firstChild = branch3D.getGroup().getChild(0);
        BasicTreeBranch3DTest.assertTrue((boolean)(firstChild instanceof BranchGroup));
        BranchGroup branchGroup = (BranchGroup)firstChild;
        int nbPartsFound = 0;
        Structure3DHelper.assertExactlyOneTransformGroup(branchGroup);
        TransformGroup firstTransformGroup = (TransformGroup)branchGroup.getChild(0);
        nbPartsFound = this.checkCurrentTransformGroup(nbPartsFound, firstTransformGroup);
        BasicTreeBranch3DTest.assertEquals((int)this.nbParts, (int)nbPartsFound);
    }

    private int checkCurrentTransformGroup(int nbPartsFound, TransformGroup transformGroup) {
        BranchGroup branchGroupPart;
        if (nbPartsFound == this.nbParts) {
            return nbPartsFound;
        }
        if (nbPartsFound == 0) {
            Structure3DHelper.assertExactlyOneBranchGroup(transformGroup);
            branchGroupPart = (BranchGroup)transformGroup.getChild(0);
        } else {
            branchGroupPart = (BranchGroup)transformGroup.getChild(1);
        }
        Structure3DHelper.assertExactlyOneTransformGroup(branchGroupPart);
        TransformGroup transformGroupPart = (TransformGroup)branchGroupPart.getChild(0);
        Transform3D transform3D = new Transform3D();
        transformGroupPart.getTransform(transform3D);
        Vector3d translationVector = new Vector3d();
        transform3D.get(translationVector);
        Vector3d expectedTranslationVector = new Vector3d((Tuple3d)this.previousPartEndPoints.get(nbPartsFound).toPointValue());
        VectorTestHelper.assertVectorEquals(expectedTranslationVector, translationVector);
        Group groupPart = (Group)transformGroupPart.getChild(0);
        BasicTreeBranch3DTest.assertNotNull((Object)groupPart);
        return this.checkCurrentTransformGroup(nbPartsFound + 1, transformGroupPart);
    }
}

