/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j3d.helper;

import javax.media.j3d.Appearance;
import javax.media.j3d.Material;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;
import junit.framework.Assert;

public final class ColorTestHelper
extends Assert {
    private ColorTestHelper() {
    }

    public static void testColorFromColoringAttributes(Appearance appearance, Color3f expectedColor) {
        ColorTestHelper.assertNotNull((Object)appearance);
        Color3f actualColor = new Color3f();
        ColorTestHelper.assertFalse((boolean)expectedColor.equals((Tuple3f)actualColor));
        appearance.getColoringAttributes().getColor(actualColor);
        ColorTestHelper.assertEquals((Object)expectedColor, (Object)actualColor);
    }

    public static void testColorFromMaterial(Appearance appearance, Color3f expectedAmbientColor, Color3f expectedSpecularColor, Color3f expectedDiffuseColor) {
        ColorTestHelper.assertNotNull((Object)appearance);
        Material material = appearance.getMaterial();
        ColorTestHelper.assertNotNull((Object)material);
        Color3f actualAmbientColor = new Color3f();
        material.getAmbientColor(actualAmbientColor);
        ColorTestHelper.assertEquals((Object)expectedAmbientColor, (Object)actualAmbientColor);
        Color3f actualSpecularColor = new Color3f();
        material.getSpecularColor(actualSpecularColor);
        ColorTestHelper.assertEquals((Object)expectedSpecularColor, (Object)actualSpecularColor);
        Color3f actualDiffuseColor = new Color3f();
        material.getDiffuseColor(actualDiffuseColor);
        ColorTestHelper.assertEquals((Object)expectedDiffuseColor, (Object)actualDiffuseColor);
    }
}

